/*
 * Decompiled with CFR 0.152.
 */
package com.aurea.maven.plugins.sonic.esb;

import com.aurea.maven.plugins.sonic.esb.EsbPackageMojo;
import com.aurea.maven.plugins.sonic.utils.FileUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public class ConnectPackageMojo
extends EsbPackageMojo {
    private MavenSession session;
    protected BuildPluginManager pluginManager;
    ArtifactHandler handler;
    protected String connectSpringLocation;
    protected String connectPropertiesLocation;
    protected String connectServicesFolder;

    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Packaging Sonic Connect artifact");
        this.project.getArtifact().setArtifactHandler(this.handler);
        try {
            this.createConnectFiles();
            this.copyLibFilesToPackageDir();
            super.doExecute();
        }
        catch (MojoExecutionException e) {
            this.getLog().error((CharSequence)("Error packaging Sonic Connect artifact : " + e.getMessage()), (Throwable)e);
            throw new MojoExecutionException("Error packaging Sonic Connect artifact : ", (Exception)((Object)e));
        }
    }

    private void copyLibFilesToPackageDir() throws MojoExecutionException {
        String targetLibDir = this.getPackageXarDir() + "/SonicFS/workspace/" + this.getProjectName() + "/lib";
        try {
            FileUtilities.copyFiles(this.project.getBasedir() + "/lib", targetLibDir);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MojoExecutionException("Error copy files from lib directory: " + e.getMessage(), e);
        }
    }

    protected void createConnectFiles() throws MojoExecutionException {
        String packagedConnectFileTemplate = this.project.getBasedir() + "/lib/" + this.getProjectName();
        File connectCsarFile = new File(packagedConnectFileTemplate + ".csar");
        File connectPropertiesFile = new File(packagedConnectFileTemplate + ".properties");
        String baseDir = this.project.getBasedir().getAbsolutePath();
        connectCsarFile.getParentFile().mkdirs();
        connectCsarFile.delete();
        connectPropertiesFile.delete();
        this.refreshDependenciesInLib();
        try {
            String[] wsdlFileNames;
            String[] esbCamelFiles;
            ZipArchiver za = new ZipArchiver();
            za.setDestFile(connectCsarFile);
            za.addFile(new File(baseDir, this.connectSpringLocation), "config/spring.xml");
            String servicesDir = new File(baseDir, this.connectServicesFolder).getPath();
            for (String fileName : esbCamelFiles = FileUtilities.getFileList(servicesDir, "**/*.esbcamel", null)) {
                File file = new File(servicesDir, fileName);
                za.addFile(file, ".services/" + fileName);
            }
            for (String fileName : wsdlFileNames = FileUtilities.getFileList(baseDir, "**/*.wsdl,**/*.xsd", null)) {
                za.addFile(new File(baseDir, fileName), fileName);
            }
            String jarFileName = this.project.getArtifactId() + "-" + this.project.getVersion() + ".jar";
            za.addFile(new File(this.project.getBuild().getDirectory(), jarFileName), jarFileName);
            String[] dependentJars = new String[]{"*.jar"};
            za.addDirectory(new File(baseDir, "lib"), dependentJars, null);
            za.createArchive();
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        SortedProperties completePropertyList = new SortedProperties();
        try {
            String[] servicesPropertiesFileNames;
            String[] topLevelPropertiesFileNames;
            String connectProperties = this.connectPropertiesLocation != null ? this.connectPropertiesLocation : this.project.getArtifactId() + ".properties";
            for (String fileName : topLevelPropertiesFileNames = FileUtilities.getFileList(baseDir, connectProperties, null)) {
                Properties props = new Properties();
                props.load(new FileInputStream(new File(baseDir, fileName)));
                completePropertyList.putAll((Map<?, ?>)props);
            }
            for (String fileName : servicesPropertiesFileNames = FileUtilities.getFileList(new File(baseDir, this.connectServicesFolder).getAbsolutePath(), "**/*.properties", null)) {
                Properties props = new Properties();
                props.load(new FileInputStream(new File(new File(baseDir, this.connectServicesFolder), fileName)));
                completePropertyList.putAll((Map<?, ?>)props);
            }
            completePropertyList.store(new FileOutputStream(new File(new File(baseDir, "lib"), this.project.getArtifactId() + ".properties")), "Generated by maven-sonicesb-plugin:connect-package");
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private void refreshDependenciesInLib() throws MojoExecutionException {
        String libDirName = this.project.getBasedir() + "/lib/";
        File markersDirectory = new File(libDirName, "markers");
        FileUtilities.deleteFilesInDir(this.project.getBasedir() + "/lib/", "*", "");
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-dependency-plugin"), (String)MojoExecutor.version((String)"2.7")), (String)MojoExecutor.goal((String)"copy-dependencies"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"outputDirectory"), (String)(this.project.getBasedir() + "/lib")), MojoExecutor.element((String)MojoExecutor.name((String)"includeScope"), (String)"runtime"), MojoExecutor.element((String)MojoExecutor.name((String)"markersDirectory"), (String)markersDirectory.getAbsolutePath()), MojoExecutor.element((String)MojoExecutor.name((String)"includeTypes"), (String)"jar"), MojoExecutor.element((String)MojoExecutor.name((String)"useRepositoryLayout"), (String)"false"), MojoExecutor.element((String)MojoExecutor.name((String)"useSubDirectoryPerType"), (String)"false")}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.pluginManager));
        try {
            FileUtils.deleteDirectory((File)markersDirectory);
        }
        catch (IOException e) {
            this.getLog().error((Throwable)e);
        }
    }

    class SortedProperties
    extends Properties {
        SortedProperties() {
        }

        @Override
        public Enumeration keys() {
            Enumeration<Object> keysEnum = super.keys();
            Vector<Object> keyList = new Vector<Object>();
            while (keysEnum.hasMoreElements()) {
                keyList.add(keysEnum.nextElement());
            }
            Collections.sort(keyList);
            return keyList.elements();
        }
    }
}

