/*
 * Decompiled with CFR 0.152.
 */
package com.aurea.maven.plugins.sonic;

import com.aurea.maven.plugins.sonic.utils.DependencyAnalyzer;
import com.aurea.maven.plugins.sonic.utils.RegexUtil;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;

public abstract class AbstractSonicMojo
extends AbstractMojo {
    protected final File deployGenSrcDir = null;
    private String sdmDirName = "sdm";
    private boolean includeVersionInXarName;
    private String sonicFSProjectRoot;
    private String sonicFSProjectDir;
    protected String defaultTopologyPrefix;
    private String sonicFSResourcesRoot;
    protected MavenProject project;
    private String systemTempDir = null;
    private String pluginTempDir = null;
    protected File sonicesbSourceDirectory;
    protected File sonicesbTestSourceDirectory;
    protected File sonicesbGeneratedSourceDirectory;
    private String projectName = null;
    protected static final String XARS_DIR_NAME = "xars";
    protected static final String TAILOR_DIR_NAME = "tailor";
    protected static final String SDM_SNIPPET_DIR_NAME = "sdm-snippets";
    private String classifier;

    protected File getTargetTopologyDir() {
        return new File(this.getOutputDirectory(), "sonicesb/topology");
    }

    protected String getGroupId() {
        return this.project.getGroupId();
    }

    protected String getArtifactId() {
        return this.project.getArtifactId();
    }

    protected String getVersion() {
        return this.project.getVersion();
    }

    protected String getFinalAssemblyBaseName() {
        return this.getFinalAssemblyBaseName(this.includeVersionInXarName);
    }

    protected String getFinalAssemblyBaseName(boolean includeVersion) {
        String classifierSuffix = "";
        if (this.getClassifier() != null) {
            classifierSuffix = this.getClassifier().trim().length() > 0 && !this.getClassifier().startsWith("-") ? "-" + this.getClassifier() : this.getClassifier();
        }
        String result = this.project.getBuild().getFinalName();
        if (!includeVersion) {
            result = this.project.getArtifact().getArtifactId();
        }
        return result + classifierSuffix;
    }

    protected String getFinalAssemblyFileName() {
        String extension = this.project.getArtifact().getArtifactHandler().getExtension();
        if (extension == null || "".equals(extension)) {
            extension = this.project.getPackaging();
        }
        return this.getFinalAssemblyBaseName(true) + "." + extension;
    }

    protected String getOutputDirectory() {
        return this.project.getBuild().getDirectory();
    }

    protected String getDependencyDirectory() {
        return this.getOutputDirectory() + "/sonicesb/dependency";
    }

    protected String getTestDependencyDirectory() {
        return this.getOutputDirectory() + "/sonicesb/testDependency";
    }

    protected File getSonicEsbSourceDirectory() {
        return this.sonicesbSourceDirectory;
    }

    protected File getSonicEsbTestSourceDirectory() {
        return this.sonicesbTestSourceDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getProjectName() {
        File projectFile = null;
        if (this.projectName == null) {
            try {
                projectFile = new File(this.project.getBasedir(), ".project");
                if (projectFile.exists() && projectFile.isFile() && projectFile.canRead()) {
                    XmlStreamReader reader = new XmlStreamReader(projectFile);
                    Xpp3Dom projectDom = Xpp3DomBuilder.build((Reader)reader);
                    this.projectName = projectDom.getChild("name").getValue();
                }
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)("Cannot read project file: " + projectFile.getAbsolutePath()), (Throwable)e);
            }
            finally {
                if (this.projectName == null) {
                    this.projectName = this.project.getArtifactId() + "-" + this.getVersion();
                }
            }
            this.getLog().debug((CharSequence)("Resolved project name to: " + this.projectName));
        }
        return this.projectName;
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"=========================================================================");
        this.getLog().info((CharSequence)("Executing Mojo : " + ((Object)((Object)this)).getClass().getName()));
        this.getLog().info((CharSequence)("Project        : " + this.getArtifactId()));
        this.getLog().info((CharSequence)("Group          : " + this.getGroupId()));
        this.getLog().info((CharSequence)("Version        : " + this.getVersion()));
        this.getLog().info((CharSequence)("Project Name   : " + this.getProjectName()));
        this.getLog().info((CharSequence)("Source         : " + this.getSonicEsbSourceDirectory().getAbsolutePath()));
        this.getLog().info((CharSequence)("Build          : " + this.getOutputDirectory()));
        this.getLog().info((CharSequence)("BaseDirectory  : " + this.project.getBasedir()));
        this.getLog().info((CharSequence)("SonicFS dir    : " + this.getSonicFSProjectDir()));
        this.setPluginTempDir();
        this.doExecute();
        this.resetTempDir();
        this.getLog().info((CharSequence)"======================= Mojo finished ===================================");
    }

    protected String getESBVersion() {
        return this.project.getProperties().getProperty("esb.version", "14.0");
    }

    protected String getSonicFSProjectRoot() {
        return this.sonicFSProjectRoot;
    }

    protected String getSonicFSProjectDir() {
        if (this.sonicFSProjectRoot == null) {
            this.sonicFSProjectRoot = "ESBArtifacts";
        }
        if (this.sonicFSProjectDir == null) {
            this.sonicFSProjectDir = "#{" + this.project.getGroupId() + "}/" + this.project.getArtifactId() + "/" + this.project.getVersion();
        }
        return this.sonicFSProjectRoot + (this.sonicFSProjectRoot.endsWith("/") ? "" : "/") + RegexUtil.applyReplaceFunction(this.sonicFSProjectDir, ".", "/");
    }

    protected String getSonicFSResourcesDir() {
        return this.sonicFSResourcesRoot;
    }

    protected String getSDMDir() {
        return this.getOutputDirectory() + "/" + this.sdmDirName;
    }

    protected abstract void doExecute() throws MojoExecutionException, MojoFailureException;

    private void setPluginTempDir() {
        this.systemTempDir = System.getProperty("java.io.tmpdir");
        String pluginDirName = this.getGroupId() + "--" + this.getArtifactId() + "--" + this.getVersion();
        pluginDirName = "mvnesbplugin" + pluginDirName.hashCode() + System.currentTimeMillis();
        File f = new File(this.systemTempDir, pluginDirName);
        f.mkdirs();
        this.pluginTempDir = f.getAbsolutePath();
        System.setProperty("java.io.tmpdir", this.pluginTempDir);
    }

    private void resetTempDir() {
        System.setProperty("java.io.tmpdir", this.systemTempDir);
        this.getLog().debug((CharSequence)("Deleting directory : " + this.pluginTempDir));
        try {
            FileUtils.deleteDirectory((File)new File(this.pluginTempDir));
        }
        catch (IOException ioe) {
            this.getLog().warn((CharSequence)("Temporary directory could not be deleted: " + this.pluginTempDir));
        }
    }

    protected String getSonicEsbSourceDirectoryFromBase() {
        return this.getSonicEsbSourceDirectory().getAbsolutePath().replace(this.project.getBasedir().getAbsolutePath(), "").replaceAll("\\\\", "/");
    }

    protected String getClassifier() {
        return this.classifier;
    }

    protected String getPackageXarDir() {
        return this.getOutputDirectory() + "/sonicesb/packageXar/fileSystem";
    }

    protected String getPackageXarFileDir() {
        return this.getOutputDirectory() + File.separator + "sonicesb" + File.separator + "packageXar";
    }

    protected String getInlineESBDir() {
        return this.getOutputDirectory() + "/sonicesb/packageXar/inlineSystem";
    }

    protected void copyJarFiles() throws Exception {
        this.getLog().info((CharSequence)"Copying jar files into xar archive ...");
        DependencyAnalyzer da = new DependencyAnalyzer(this.getDependencyDirectory());
        for (String jarFile : da.getUnpackagedJarFiles()) {
            this.getLog().info((CharSequence)("Copying: " + this.getDependencyDirectory() + "/" + jarFile));
            File src = new File(da.getJarDependencyDir(), jarFile);
            File dest = new File(this.getPackageXarDir(), "SonicFS/" + this.getSonicFSResourcesDir() + "/" + jarFile);
            FileUtils.copyFile((File)src, (File)dest);
        }
        this.getLog().debug((CharSequence)"Leaving copyJarFile");
    }
}

