/*
 * Decompiled with CFR 0.152.
 */
package com.aurea.maven.plugins.sonic.esb;

import com.aurea.maven.plugins.sonic.AbstractSonicMojo;
import com.aurea.maven.plugins.sonic.utils.FileUtilities;
import com.aurea.maven.plugins.sonic.utils.ProjectAnalyzer;
import com.progress.sonic.utilities.esb.admin.XarAnalyzer;
import com.sonicsw.deploy.IArtifact;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractESBMojo
extends AbstractSonicMojo {
    protected final File deployGenSrcDir = null;
    protected final File testDeployGenSrcDir = null;
    protected File targetGenTestSrcDir;
    protected File xarUnzipDir;

    protected HashSet<String> getDependencyProcessNames() {
        String[] xarFiles;
        HashSet<String> hs = new HashSet<String>();
        for (String currXarFile : xarFiles = FileUtilities.getFileList(this.getDependencyDirectory(), "**/*.xar", null)) {
            File currXarFullPath = new File(this.getDependencyDirectory(), currXarFile);
            XarAnalyzer xa = new XarAnalyzer(currXarFullPath);
            List aa = xa.getAllArtifacts();
            this.getLog().debug((CharSequence)("    Searching xar: " + currXarFullPath.getAbsolutePath()));
            this.getLog().debug((CharSequence)("    Found artifacts: " + aa));
            for (IArtifact artifact : aa) {
                this.getLog().debug((CharSequence)("      getName: " + artifact.getName()));
                this.getLog().debug((CharSequence)("      getPath: " + artifact.getPath()));
                this.getLog().debug((CharSequence)("      getRootDirectory: " + artifact.getRootDirectory()));
                if (!"Processes".equals(artifact.getRootDirectory())) continue;
                hs.add(artifact.getName());
            }
        }
        return hs;
    }

    protected void copyProcessFilesReplacingEsbpWithXml(String _srcDir, String _targetDir) {
        this.getLog().info((CharSequence)("Copying process files from " + _srcDir + " to " + _targetDir));
        new File(_targetDir, "ESB").mkdirs();
        new File(_targetDir, "SonicFS").mkdirs();
        this.getLog().debug((CharSequence)"TBO: Directories Created: ESB + SonicFS");
        this.getLog().debug((CharSequence)("TBO: Source-Directory: " + _srcDir));
        for (File processFile : ProjectAnalyzer.getProcessSourceFiles(_srcDir)) {
            this.getLog().debug((CharSequence)("TBO: ProcessFile: " + processFile));
            try {
                this.getLog().info((CharSequence)("  Found process file : " + processFile));
                File processTargetFile = new File(_targetDir, "ESB/Processes/" + ProjectAnalyzer.getProcessNameFromFile(processFile) + ".xml");
                processTargetFile.getParentFile().mkdirs();
                FileUtils.copyFile((File)processFile, (File)processTargetFile);
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)("  Error copying process file :" + processFile + e.getMessage()));
            }
        }
    }
}

