/*
 * Decompiled with CFR 0.152.
 */
package com.aurea.maven.plugins.sonic.utils;

import com.progress.sonic.utilities.mfutils.MFUtils;
import com.sonicsw.deploy.IArtifact;
import com.sonicsw.deploy.IArtifactStorage;
import com.sonicsw.deploy.IArtifactTraversalContext;
import com.sonicsw.deploy.IArtifactTraverser;
import com.sonicsw.deploy.artifact.ESBArtifact;
import com.sonicsw.deploy.tools.common.ExportPropertiesArtifact;
import com.sonicsw.deploy.traversal.AbstractTraverser;
import com.sonicsw.deploy.traversal.TraverserContext;
import com.sonicsw.deploy.traversal.TraverserFactory;
import com.sonicsw.esb.mgmtapi.ESBAPI;
import com.sonicsw.esb.mgmtapi.ESBAPIFactory;
import com.sonicsw.esb.mgmtapi.config.IContainerConfig;
import com.sonicsw.esb.mgmtapi.config.IProcessConfig;
import com.sonicsw.esb.mgmtapi.config.IProcessConfigAPI;
import com.sonicsw.esb.mgmtapi.config.IServiceConfig;
import com.sonicsw.esb.mgmtapi.config.IServiceConfigAPI;
import java.util.ArrayList;
import java.util.List;

public class ProcessDependencyFinder {
    private String[] processName = new String[]{"testProcess", "ESBPluginTester", "Proc.Dealer_CarLookup", "Proc.RecreateToyotaEnvironment"};
    private MFUtils mfutil;
    private boolean failOnError = true;

    public static void main(String[] _args) {
        ProcessDependencyFinder pdf = new ProcessDependencyFinder();
        pdf.go();
    }

    private void disconnect() {
        this.mfutil.cleanup();
    }

    private void connect() {
        this.mfutil = new MFUtils("Domain1", "tcp://localhost:2506", "Administrator", "Administrator");
    }

    private void go() {
        this.connect();
        ExportPropertiesArtifact exportprop = new ExportPropertiesArtifact();
        for (String process : this.processName) {
            System.out.println("Searching for process: " + process);
            ESBArtifact artifact = new ESBArtifact(ESBArtifact.PROCESS, process);
            exportprop.addRoot((IArtifact)artifact);
        }
        IArtifact[] deptree = this.lookup(exportprop);
        String[][] depitems = this.filterContainerItems(deptree);
        depitems[0] = this.processName;
        this.listArtifacts(depitems);
        this.disconnect();
        this.addArtifactsToContainer(depitems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addArtifactsToContainer(String[][] _depitems) {
        System.out.println("addArtifactsToContainer");
        ESBAPI eapi = null;
        try {
            IProcessConfig pro;
            IProcessConfigAPI proconf;
            System.out.println("Creating ESB API Factory");
            ESBAPIFactory efac = ESBAPIFactory.createESBAPIFactory();
            System.out.println("Factory API Created");
            System.out.println("Creating the API Handle");
            eapi = efac.createAPI("Domain1", "tcp://localhost:2506", "Administrator", "Administrator");
            System.out.println("API Handle Created");
            System.out.println("Getting the Container");
            IContainerConfig esbContainer = eapi.getContainerConfigAPI().getESBContainer("TestDomainESB");
            System.out.println("Adding the Services");
            for (String service : _depitems[2]) {
                System.out.println("Adding Service: " + service);
                IServiceConfigAPI svcconf = eapi.getServiceConfigAPI();
                IServiceConfig svc = svcconf.getServiceConfig(service);
                try {
                    svc.addToContainer(esbContainer, 1);
                    eapi.getContainerConfigAPI().saveESBContainer(esbContainer);
                }
                catch (Exception e) {
                    System.out.println("MSG: " + e.getMessage());
                }
            }
            System.out.println("Adding the Main Processes");
            for (String process : _depitems[0]) {
                System.out.println("Adding Process: " + process);
                proconf = eapi.getProcessConfigAPI();
                pro = proconf.getProcess(process);
                if (pro.getEntryEndpointConfig() == null) {
                    System.out.println("No Endpoint Config found ... skipping the add to the container");
                    continue;
                }
                if (pro.getEntryEndpointConfig().getName() == null || pro.getEntryEndpointConfig().getName().equals("")) {
                    System.out.println("No Endpoint Name Found ... skipping the add to the container");
                    continue;
                }
                try {
                    pro.addToContainer(esbContainer, 1);
                    eapi.getContainerConfigAPI().saveESBContainer(esbContainer);
                }
                catch (Exception e) {
                    System.out.println("MSG: " + e.getMessage());
                }
            }
            System.out.println("Adding the sub Processes");
            for (String process : _depitems[1]) {
                System.out.println("Adding Process: " + process);
                proconf = eapi.getProcessConfigAPI();
                pro = proconf.getProcess(process);
                if (pro.getEntryEndpointConfig() == null) {
                    System.out.println("No Endpoint Config found ... skipping the add to the container");
                    continue;
                }
                if (pro.getEntryEndpointConfig().getName() == null || pro.getEntryEndpointConfig().getName().equals("")) {
                    System.out.println("No Endpoint Name Found ... skipping the add to the container");
                    continue;
                }
                try {
                    pro.addToContainer(esbContainer, 1);
                    eapi.getContainerConfigAPI().saveESBContainer(esbContainer);
                }
                catch (Exception e) {
                    System.out.println("MSG: " + e.getMessage());
                }
            }
        }
        catch (Exception e) {
            System.out.println("Error happened: " + e.getMessage());
        }
        finally {
            eapi.dispose();
        }
        System.out.println("addArtifactsToContainer Done");
    }

    private String[][] filterContainerItems(IArtifact[] _deptree) {
        String[][] returnList = new String[3][];
        int procCounter = this.countProcesses(_deptree);
        returnList[1] = new String[procCounter];
        int svcCounter = this.countSvc(_deptree);
        returnList[2] = new String[svcCounter];
        int countsvc = 0;
        int countpro = 0;
        for (IArtifact a : _deptree) {
            if (a.getPath().startsWith("/Services/")) {
                returnList[2][countsvc] = a.getName();
                ++countsvc;
            }
            if (!a.getPath().startsWith("/Processes/")) continue;
            returnList[1][countpro] = a.getName();
            ++countpro;
        }
        return returnList;
    }

    private int countSvc(IArtifact[] _deptree) {
        int count = 0;
        for (IArtifact a : _deptree) {
            if (!a.getPath().startsWith("/Services/")) continue;
            ++count;
        }
        return count;
    }

    private int countProcesses(IArtifact[] _deptree) {
        int count = 0;
        for (IArtifact a : _deptree) {
            if (!a.getPath().startsWith("/Processes/")) continue;
            ++count;
        }
        return count;
    }

    private void listArtifacts(String[][] _depitems) {
        System.out.println("Listing Main Processes");
        for (String art : _depitems[0]) {
            System.out.println("Process Name: " + art);
        }
        System.out.println("Listing Processes");
        for (String art : _depitems[1]) {
            System.out.println("Process Name: " + art);
        }
        System.out.println("Listing Services");
        for (String art : _depitems[2]) {
            System.out.println("Service Name: " + art);
        }
    }

    private IArtifact[] lookup(ExportPropertiesArtifact _processes) {
        ExportPropertiesArtifact processes = _processes;
        if (processes == null) {
            processes = new ExportPropertiesArtifact();
        }
        List<IArtifact> ignores = this.filterIgnoreList(processes.getIgnoreList());
        processes.clearIgnoreList();
        processes.addIgnore(ignores.toArray(new IArtifact[0]));
        try {
            TraverserContext ctxt = new TraverserContext((IArtifactStorage)this.mfutil.getDSArtifactStorage(), processes.getIgnoreList());
            ctxt.setTraverseCompressed(false);
            for (int i = 0; i < processes.getRootList().length; ++i) {
                IArtifactTraverser traverser = TraverserFactory.createTraverser((IArtifact)processes.getRootList()[i]);
                ((AbstractTraverser)traverser)._traverse((IArtifactTraversalContext)ctxt);
            }
            IArtifact[] errored = ctxt.getErrored();
            if (errored.length > 0) {
                StringBuffer buf = new StringBuffer();
                buf.append("The following Artifacts could not be traversed : [\n");
                for (IArtifact error : errored) {
                    buf.append("  " + error.getDisplayType() + ":" + error.getPath() + "\n");
                }
                buf.append("]\n");
                if (this.failOnError) {
                    throw new Exception(buf.toString());
                }
            }
            IArtifact[] result = ctxt.completeTraversal();
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private List<IArtifact> filterIgnoreList(IArtifact[] _ignores) {
        ArrayList<IArtifact> result = new ArrayList<IArtifact>();
        ArrayList<String> invalidIgnores = new ArrayList<String>();
        invalidIgnores.add("/Connections/http_defaultConnection");
        invalidIgnores.add("/Connections/jms_defaultConnection");
        invalidIgnores.add("/System/");
        for (IArtifact a : _ignores) {
            if (invalidIgnores.contains(a.getPath())) continue;
            result.add(a);
        }
        return result;
    }
}

