/*
 * Decompiled with CFR 0.152.
 */
package com.aurea.maven.plugins.sonic.sdm.container.impl;

import com.aurea.maven.plugins.sonic.sdm.container.IMFContainer;
import com.aurea.maven.plugins.sonic.sdo.AbstractDataObjectInstance;
import commonj.sdo.DataObject;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;

public class DefaultMFContainer
extends AbstractDataObjectInstance
implements IMFContainer {
    @Override
    protected String getNamespace() {
        return "http://www.soa-knowledge.net/ESBPlugin";
    }

    @Override
    protected String getXSDType() {
        return "ESBContainer";
    }

    @Override
    protected String getResourceLocation() {
        return "schema/MFContainer.xsd";
    }

    public DefaultMFContainer(String _name, String _targetContainer, boolean _bootContainer, String _backupContainer, String _hosts, boolean _clone) {
        this.doInit(_name, _targetContainer, _bootContainer, _backupContainer, _hosts, _clone);
    }

    @Override
    public String getSegment() {
        return this.getDataObject().getString("Segment");
    }

    @Override
    public String getLogDirectory() {
        return this.getDataObject().getString("LogDirectory");
    }

    @Override
    public String getContainerParameterSet() {
        return this.getDataObject().getString("ContainerParameterSet");
    }

    @Override
    public String getName() {
        return this.getDataObject().getString("Id");
    }

    @Override
    public boolean isBootContainer() {
        return this.getDataObject().getBoolean("BootContainer");
    }

    @Override
    public boolean isClone() {
        return this.getDataObject().getBoolean("Clone");
    }

    private void doInit(String _name, String _targetContainer, boolean _bootContainer, String _backupContainer, String _hosts, boolean _clone) {
        DataObject dObj = this.getDataObject();
        dObj.set("Id", (Object)_name);
        if (_targetContainer != null) {
            dObj.set("TargetContainer", (Object)_targetContainer);
        }
        dObj.set("BootContainer", (Object)_bootContainer);
        if (StringUtils.isNotEmpty((String)_backupContainer)) {
            dObj.set("BackupContainer", (Object)_backupContainer);
            dObj.set("Clone", (Object)_clone);
        }
        if (_hosts != null) {
            DataObject obj = dObj.createDataObject("Hosts");
            obj.setList("Host", Arrays.asList(_hosts.split(",")));
        }
    }

    public void addHosts(String _hosts) {
        if (_hosts == null) {
            return;
        }
        DataObject obj = this.getDataObject().getDataObject("Hosts");
        if (obj == null) {
            obj = this.getDataObject().createDataObject("Hosts");
            obj.setList("Host", Arrays.asList(_hosts.split(",")));
        } else {
            ArrayList<String> hostList = new ArrayList<String>();
            hostList.addAll(obj.getList("Host"));
            for (String host : _hosts.split(",")) {
                if (hostList.contains(host)) continue;
                hostList.add(host);
            }
            obj.setList("Host", hostList);
        }
    }

    @Override
    public Xpp3Dom removeNamespaces() {
        Xpp3Dom element = new Xpp3Dom("ESBContainer");
        try {
            Xpp3Dom dom = Xpp3DomBuilder.build((Reader)new StringReader(this.toString()));
            for (Xpp3Dom child : dom.getChildren()) {
                element.addChild(child);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return element;
    }

    @Override
    public Xpp3Dom removeNamespaces8() {
        Xpp3Dom element = new Xpp3Dom("ESBContainer");
        try {
            Xpp3Dom dom = Xpp3DomBuilder.build((Reader)new StringReader(this.toString()));
            for (Xpp3Dom child : dom.getChildren()) {
                if (child.getName().equals("Hosts")) {
                    Xpp3Dom changeHosts = new Xpp3Dom("LogicalHosts");
                    changeHosts.setValue(child.getValue());
                    for (Xpp3Dom changeHost : child.getChildren()) {
                        Xpp3Dom logicalHost = new Xpp3Dom("LogicalHost");
                        logicalHost.setValue(changeHost.getValue());
                        changeHosts.addChild(logicalHost);
                    }
                    element.addChild(changeHosts);
                    continue;
                }
                element.addChild(child);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return element;
    }
}

