/*
 * Decompiled with CFR 0.152.
 */
package com.aurea.maven.plugins.sonic.sdm.util;

import com.aurea.maven.plugins.sonic.sdm.util.ESBDeploymentModel;
import com.aurea.maven.plugins.sonic.sdm.util.ESBDeploymentModelBuilder;
import com.aurea.maven.plugins.sonic.sdm.util.ESBModelContribution;
import com.aurea.maven.plugins.util.JAXBHelper;
import com.progress.sonic.utilities.esb.admin.XarAnalyzer;
import com.sonicsw.deploy.IArtifact;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractModelContribution
implements ESBModelContribution {
    private ESBDeploymentModelBuilder builder = null;
    private String contributionName = null;

    public AbstractModelContribution(String contributionName, ESBDeploymentModelBuilder builder) {
        this.builder = builder;
        this.contributionName = contributionName;
    }

    @Override
    public String getContributionName() {
        return this.contributionName;
    }

    protected ESBDeploymentModelBuilder getBuilder() {
        return this.builder;
    }

    protected List<Object> getArtifactList(IArtifact type, Class<?> javaType) throws Exception {
        ArrayList<Object> result = new ArrayList<Object>();
        ESBDeploymentModel model = this.getBuilder().getModel();
        for (String xarFileName : (List)model.getModelObject("xarFiles")) {
            File xarFile = new File(this.getBuilder().getSDMDir() + "/xars", xarFileName);
            this.getBuilder().getLog().debug((CharSequence)("Analyzing [" + xarFile.getAbsolutePath() + "] for " + type.getDisplayType()));
            XarAnalyzer analyzer = new XarAnalyzer(xarFile);
            List artifacts = analyzer.getArtifacts(type);
            this.getBuilder().getLog().debug((CharSequence)("Found [" + artifacts.size() + "] artifacs."));
            for (IArtifact artifact : artifacts) {
                byte[] rawXml = analyzer.getContent(artifact);
                Object obj = JAXBHelper.unmarshal(javaType, new ByteArrayInputStream(rawXml));
                this.getBuilder().getLog().debug((CharSequence)("Analyzed Artifact []: " + artifact.getName()));
                result.add(obj);
            }
        }
        return result;
    }
}

