/*
 * Decompiled with CFR 0.152.
 */
package com.aurea.maven.plugins.sonic.utils.xmlsorter;

import com.aurea.maven.plugins.sonic.utils.xmlsorter.AttributeNameComparator;
import com.aurea.maven.plugins.sonic.utils.xmlsorter.DefaultNodeNameComparator;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.Xpp3DomWriter;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.w3c.dom.Text;

public class XMLSort {
    public static void sortXMLFile(File file) throws IOException {
        try {
            XmlStreamReader inputReader = new XmlStreamReader(file);
            Xpp3Dom fileDom = Xpp3DomBuilder.build((Reader)inputReader);
            XMLSort.sortChildNodes(fileDom, 2, new AttributeNameComparator());
            FileWriter writer = new FileWriter(file);
            Xpp3DomWriter.write((Writer)writer, (Xpp3Dom)fileDom);
            writer.close();
        }
        catch (XmlPullParserException e) {
            throw new IOException("Could not parse XML file " + file.getAbsolutePath());
        }
    }

    public static void sortChildNodes(Xpp3Dom dom, int depth, Comparator<Xpp3Dom> comparator) {
        DefaultNodeNameComparator comp = comparator != null ? comparator : new DefaultNodeNameComparator();
        ArrayList<Xpp3Dom> xpp3Doms = new ArrayList<Xpp3Dom>();
        for (int i = 0; i < dom.getChildCount(); ++i) {
            Xpp3Dom child = dom.getChild(i);
            if (depth > 1) {
                XMLSort.sortChildNodes(child, depth - 1, comparator);
            }
            if (child instanceof Text && (!(child instanceof Text) || ((Text)child).getTextContent().trim().length() <= 1)) continue;
            xpp3Doms.add(child);
        }
        Collections.sort(xpp3Doms, comp);
        while (dom.getChildCount() > 0) {
            dom.removeChild(0);
        }
        for (Xpp3Dom xpp3Dom : xpp3Doms) {
            dom.addChild(xpp3Dom);
        }
    }
}

