/*
 * Decompiled with CFR 0.152.
 */
package no.geosoft.cc.util;

import java.util.ArrayList;
import java.util.StringTokenizer;

public class SmartTokenizer {
    private ArrayList<String> tokens_ = new ArrayList();
    private int current_ = 0;

    public SmartTokenizer(String string, String delimiter) {
        StringTokenizer tokenizer = new StringTokenizer(string, delimiter, true);
        boolean wasDelimiter = true;
        boolean isDelimiter = false;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            isDelimiter = token.equals(delimiter);
            if (wasDelimiter) {
                this.tokens_.add(isDelimiter ? "" : token);
            } else if (!isDelimiter) {
                this.tokens_.add(token);
            }
            wasDelimiter = isDelimiter;
        }
        if (isDelimiter) {
            this.tokens_.add("");
        }
    }

    public int countTokens() {
        return this.tokens_.size();
    }

    public boolean hasMoreTokens() {
        return this.current_ < this.tokens_.size();
    }

    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public Object nextElement() {
        return this.nextToken();
    }

    public String nextToken() {
        String token = this.tokens_.get(this.current_);
        ++this.current_;
        return token;
    }

    public static void main(String[] args) {
        SmartTokenizer t = new SmartTokenizer("This,is,a,,test,", ",");
        while (t.hasMoreTokens()) {
            String token = t.nextToken();
            System.out.println("#" + token + "#");
        }
    }
}

