/*
 * Decompiled with CFR 0.152.
 */
package com.aurea.maven.plugins.sonic.sdm;

import com.aurea.maven.plugins.sonic.sdm.AbstractSdmMojo;
import com.aurea.maven.plugins.sonic.utils.FileUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;

public class SdmValidatePropertiesMojo
extends AbstractSdmMojo {
    protected String sonicTarget;
    protected boolean failOnValidationWarning;
    protected ArchiverManager archiverManager;

    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        try {
            this.validateTopologies();
            File sdmAssemblyFile = new File(this.getOutputDirectory(), this.getFinalAssemblyFileName());
            Archiver archiver = this.archiverManager.getArchiver("zip");
            archiver.setDestFile(sdmAssemblyFile);
            archiver.addDirectory(this.getTargetSDMDir());
            this.project.getArtifact().setFile(sdmAssemblyFile);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error creating SDM Model - " + e.getMessage(), e);
        }
    }

    private void validateTopologies() throws MojoExecutionException {
        this.getLog().info((CharSequence)"Validating the Topology files");
        boolean isValid = true;
        Properties generated = null;
        Properties compare = null;
        generated = this.buildPropertiesFromTopology(this.getGeneratedTopologyFile());
        for (String toCompare : FileUtilities.getFileList(this.getTargetSDMDir().getAbsolutePath(), "*.Topology.xml", "generated.Topology.xml")) {
            this.getLog().info((CharSequence)"------------------------------------------------------------------------");
            this.getLog().info((CharSequence)("Verifying Topology file: " + toCompare));
            compare = this.buildPropertiesFromTopology(new File(this.getTargetSDMDir() + "/" + toCompare));
            isValid = this.validateProperties(generated, compare) && isValid;
        }
        if (!isValid) {
            throw new MojoExecutionException("Properties validation failed");
        }
    }

    private void validateProperties() throws MojoExecutionException {
        boolean isValid = true;
        Properties generated = null;
        Properties compare = null;
        try {
            generated = new Properties();
            FileInputStream fis = new FileInputStream(this.getGeneratedPropertiesFile());
            generated.load(fis);
            fis.close();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Could not read generated properties files: " + this.getGeneratedPropertiesFile());
        }
        for (String toCompare : FileUtilities.getFileList(this.getTargetSDMDir().getAbsolutePath(), "*.tailoring.properties", "generated.tailoring.properties")) {
            try {
                this.getLog().info((CharSequence)"------------------------------------------------------------------------");
                this.getLog().info((CharSequence)("Verifying property file: " + toCompare));
                compare = new Properties();
                FileInputStream fis = new FileInputStream(this.getTargetSDMDir() + "/" + toCompare);
                compare.load(fis);
                fis.close();
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)("Could not read " + this.getTargetSDMDir() + "/" + toCompare));
                isValid = false;
            }
            isValid = this.validateProperties(generated, compare) && isValid;
        }
        if (!isValid) {
            throw new MojoExecutionException("Properties validation failed");
        }
    }

    private boolean validateProperties(Properties _source, Properties _toCompare) {
        boolean result = true;
        for (Object key : _source.keySet()) {
            String value = _toCompare.getProperty(key.toString());
            if (value == null) {
                this.getLog().warn((CharSequence)("Property file does not contain key: " + key));
                if (!result) continue;
                result = !this.failOnValidationWarning;
                continue;
            }
            if (value.trim().length() != 0) continue;
            this.getLog().warn((CharSequence)("Property has no value defined : " + key));
            if (!result) continue;
            result = !this.failOnValidationWarning;
        }
        return result;
    }
}

