/*
 * Decompiled with CFR 0.152.
 */
package com.aurea.maven.plugins.sonic.sdm.util;

import com.aurea.maven.plugins.sonic.sdm.util.ESBDeploymentModel;
import com.aurea.maven.plugins.sonic.sdm.util.ESBModelContribution;
import com.aurea.maven.plugins.sonic.sdm.util.ESBProcessesContribution;
import com.aurea.maven.plugins.sonic.sdm.util.ESBServiceTypesContribution;
import com.aurea.maven.plugins.sonic.sdm.util.ESBServicesContribution;
import com.aurea.maven.plugins.sonic.sdm.util.XarFileContribution;
import com.aurea.maven.plugins.sonic.utils.DependencyAnalyzer;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public class ESBDeploymentModelBuilder {
    public static final String XARS_DIR_NAME = "xars";
    public static final String SDM_DIR_NAME = "sdm";
    public static final String TAILOR_DIR_NAME = "tailor";
    public static final String SDM_SNIPPET_DIR_NAME = "sdm-snippets";
    public static final String DEFAULT_SDM_HOST_VALUE = "ESBHost";
    public static final String DEFAULT_XAR_HOST_VALUE = "XARHost";
    private Log log = null;
    private MavenProject project = null;
    private DependencyAnalyzer depAnalyzer = null;
    private ESBDeploymentModel model = null;
    private ESBModelContribution[] contributions = null;

    public ESBDeploymentModelBuilder(MavenProject project, Log log) {
        this.project = project;
        this.log = log;
        this.contributions = new ESBModelContribution[]{new XarFileContribution("xarFiles", this), new ESBProcessesContribution("processes", this), new ESBServiceTypesContribution("servicetypes", this), new ESBServicesContribution("services", this)};
    }

    public ESBDeploymentModel getModel() throws Exception {
        this.getLog().info((CharSequence)"Building ESB Deployment Model...");
        if (this.model == null) {
            this.model = new ESBDeploymentModel();
            this.model.setProject(this.project);
            for (ESBModelContribution contrib : this.contributions) {
                this.model.setModelObject(contrib.getContributionName(), contrib.getContribution());
            }
        }
        return this.model;
    }

    public DependencyAnalyzer getDepAnalyzer() {
        if (this.depAnalyzer == null) {
            this.depAnalyzer = new DependencyAnalyzer(this.getDependencyDirectory());
        }
        return this.depAnalyzer;
    }

    public String getOutputDirectory() {
        return this.project.getBuild().getDirectory();
    }

    public String getDependencyDirectory() {
        return this.getOutputDirectory() + "/dependency";
    }

    public String getTestDependencyDirectory() {
        return this.getOutputDirectory() + "/sonicesb/testDependency";
    }

    public String getSDMDir() {
        return this.getOutputDirectory() + "/" + SDM_DIR_NAME;
    }

    public String getPackageXarDir() {
        return this.getOutputDirectory() + "/sonicesb/packageXar/fileSystem";
    }

    public Log getLog() {
        return this.log;
    }
}

