/*
 * Decompiled with CFR 0.152.
 */
package com.aurea.maven.plugins.sonic.utils;

import com.aurea.maven.plugins.sonic.utils.FileUtilities;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class ProjectAnalyzer {
    public static File[] getProcessSourceFiles(String _baseDir) {
        String[] processFileLocations = FileUtilities.getFileList(_baseDir, "**/*.esbp", null);
        File[] processFiles = new File[processFileLocations.length];
        for (int index = 0; index < processFileLocations.length; ++index) {
            processFiles[index] = new File(_baseDir, processFileLocations[index]);
        }
        return processFiles;
    }

    public static HashSet<String> getProcessNames(String _baseDir) {
        HashSet<String> processNames = new HashSet<String>();
        for (File processFile : ProjectAnalyzer.getProcessSourceFiles(_baseDir)) {
            String currProcName = ProjectAnalyzer.getProcessNameFromFile(processFile);
            processNames.add(currProcName);
        }
        return processNames;
    }

    public static File[] getServiceConfigSourceFiles(String _baseDir) {
        String[] serviceConfigFileLocations = FileUtilities.getFileList(_baseDir, "**/*.esbsvc", null);
        File[] serviceConfigFiles = new File[serviceConfigFileLocations.length];
        for (int index = 0; index < serviceConfigFileLocations.length; ++index) {
            serviceConfigFiles[index] = new File(_baseDir, serviceConfigFileLocations[index]);
        }
        return serviceConfigFiles;
    }

    public static File[] getServiceTypeSourceFiles(String _baseDir) {
        String[] serviceTypeFileLocations = FileUtilities.getFileList(_baseDir, "**/*.esbstyp", null);
        File[] serviceTypeFiles = new File[serviceTypeFileLocations.length];
        for (int index = 0; index < serviceTypeFileLocations.length; ++index) {
            serviceTypeFiles[index] = new File(_baseDir, serviceTypeFileLocations[index]);
        }
        return serviceTypeFiles;
    }

    public static HashSet<String> getSubProcessesOfProcesses(File _baseDir) {
        HashSet<String> subProcesses = new HashSet<String>();
        ArrayList<String> subProcessesReferenced = new ArrayList<String>();
        for (File processFile : ProjectAnalyzer.getProcessSourceFiles(_baseDir.getAbsolutePath())) {
            subProcesses.addAll(ProjectAnalyzer.getSubProcessesOfProcess(processFile));
            subProcessesReferenced.addAll(ProjectAnalyzer.getSubProcessesOfProcess(processFile));
        }
        return subProcesses;
    }

    public static HashSet<String> getSubProcessesOfProcess(File _processFile) {
        HashSet<String> hs = new HashSet<String>();
        try {
            Xpp3Dom[] steps;
            XmlStreamReader reader = new XmlStreamReader(_processFile);
            Xpp3Dom processDom = Xpp3DomBuilder.build((Reader)reader);
            Xpp3Dom itinerary = processDom.getChild("xq:itinerary");
            for (Xpp3Dom currStep : steps = itinerary.getChildren()) {
                if (!"xq:step".equals(currStep.getName()) || !"PROCESS".equals(currStep.getAttribute("type"))) continue;
                hs.add(currStep.getAttribute("endpoint_ref"));
            }
        }
        catch (IOException e) {
            System.out.println("[ERROR] Could not read process source file: " + _processFile);
            e.printStackTrace();
        }
        catch (XmlPullParserException e) {
            System.out.println("[ERROR] Could not parse process source file: " + _processFile);
            e.printStackTrace();
        }
        return hs;
    }

    public static HashSet<String> getServiceConfigsOfProcess(String _processDefinition) {
        HashSet<String> hs = new HashSet<String>();
        try {
            Xpp3Dom[] steps;
            XmlStreamReader reader = new XmlStreamReader((InputStream)new ByteArrayInputStream(_processDefinition.getBytes()));
            Xpp3Dom processDom = Xpp3DomBuilder.build((Reader)reader);
            Xpp3Dom itinerary = processDom.getChild("xq:itinerary");
            for (Xpp3Dom currStep : steps = itinerary.getChildren()) {
                if (!"xq:step".equals(currStep.getName()) || !"SERVICE".equals(currStep.getAttribute("type"))) continue;
                hs.add(currStep.getAttribute("endpoint_ref"));
            }
        }
        catch (IOException e) {
            System.out.println("[ERROR] Could not read process");
            e.printStackTrace();
        }
        catch (XmlPullParserException e) {
            System.out.println("[ERROR] Could not parse process");
            e.printStackTrace();
        }
        return hs;
    }

    public static String getProcessNameFromFile(File _processFile) {
        String processName = null;
        try {
            XmlStreamReader reader = new XmlStreamReader(_processFile);
            Xpp3Dom processDom = Xpp3DomBuilder.build((Reader)reader);
            processName = processDom.getAttribute("name");
        }
        catch (IOException e) {
            System.out.println("[ERROR] Could not read process file: " + _processFile.getName());
        }
        catch (XmlPullParserException e) {
            System.out.println("[ERROR] Could not parse process file: " + _processFile.getName());
        }
        return processName;
    }

    public static String getServiceConfigNameFromFile(File _serviceConfigFile) {
        String serviceName = null;
        try {
            XmlStreamReader reader = new XmlStreamReader(_serviceConfigFile);
            Xpp3Dom serviceConfigDom = Xpp3DomBuilder.build((Reader)reader);
            serviceName = serviceConfigDom.getAttribute("name");
        }
        catch (IOException e) {
            System.out.println("[ERROR] Could not read Service Configuration file: " + _serviceConfigFile.getName());
        }
        catch (XmlPullParserException e) {
            System.out.println("[ERROR] Could not parse Service Configuration file: " + _serviceConfigFile.getName());
        }
        return serviceName;
    }

    public static String getServiceConfigEntryRefFromFile(File _serviceConfigFile) {
        String entryRefName = null;
        try {
            XmlStreamReader reader = new XmlStreamReader(_serviceConfigFile);
            Xpp3Dom serviceConfigDom = Xpp3DomBuilder.build((Reader)reader);
            Xpp3Dom entryRef = serviceConfigDom.getChild("xq:entry_ref");
            if (entryRef != null) {
                entryRefName = entryRef.getValue();
            }
        }
        catch (IOException e) {
            System.out.println("[ERROR] Could not read Service Configuration file: " + _serviceConfigFile.getName());
        }
        catch (XmlPullParserException e) {
            System.out.println("[ERROR] Could not parse Service Configuration file: " + _serviceConfigFile.getName());
        }
        return entryRefName;
    }
}

