/*
 * Decompiled with CFR 0.152.
 */
package com.aurea.maven.plugins.util;

import java.util.HashSet;
import java.util.Set;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;

@Component(role=AbstractMavenLifecycleParticipant.class, hint="ArtifactHandlerExt")
public class ArtifactHandlerExtension
extends AbstractMavenLifecycleParticipant {
    private ArtifactHandlerManager artifactHandlerManager;
    @Requirement
    private Logger logger;

    public void afterProjectsRead(MavenSession session) {
        this.logger.info(" __  __");
        this.logger.info("|  \\/  |__ _Aurea-__ ___");
        this.logger.info("| |\\/| / _` \\ V / -_) ' \\  ~ Artifact Loader Extension ~ 1.0");
        this.logger.info("|_|  |_\\__,_|\\_/\\___|_||_|  ");
        this.logger.info("");
        MavenProject project = (MavenProject)session.getProjects().get(0);
        this.logger.info("Setting ArtifactHandler on project-artifact: " + project.getId() + "...");
        HashSet<Artifact> artifacts = new HashSet<Artifact>();
        artifacts.add(project.getArtifact());
        Set dependencyArtifacts = project.getDependencyArtifacts();
        if (dependencyArtifacts != null && !dependencyArtifacts.isEmpty()) {
            artifacts.addAll(dependencyArtifacts);
        }
        for (Artifact artifact : artifacts) {
            String type = artifact.getType();
            ArtifactHandler handler = this.artifactHandlerManager.getArtifactHandler(type);
            this.logger.debug("Artifact: " + artifact.getId() + "\nType: " + type + "\nArtifactHandler extension: " + handler.getExtension());
            artifact.setArtifactHandler(handler);
        }
        this.logger.info("...done.");
    }
}

