/*
 * Decompiled with CFR 0.152.
 */
package com.aurea.maven.plugins.sonic.sdo;

import com.aurea.maven.plugins.sonic.sdo.IDataObjectInstance;
import com.aurea.maven.plugins.sonic.utils.FileUtilities;
import commonj.sdo.DataObject;
import commonj.sdo.helper.HelperContext;
import commonj.sdo.helper.XMLDocument;
import commonj.sdo.helper.XMLHelper;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.apache.tuscany.sdo.util.SDOUtil;

public abstract class AbstractDataObjectInstance
implements IDataObjectInstance {
    private DataObject object = null;
    private static HashMap<String, HelperContext> HELPER_CONTEXT = null;

    protected abstract String getResourceLocation();

    protected abstract String getNamespace();

    protected abstract String getXSDType();

    protected final synchronized HelperContext getHelperContext() throws Exception {
        if (HELPER_CONTEXT.get(this.getResourceLocation()) == null) {
            HelperContext ctxt = SDOUtil.createHelperContext();
            InputStream is = AbstractDataObjectInstance.class.getClassLoader().getResourceAsStream(this.getResourceLocation());
            ctxt.getXSDHelper().define(is, this.getResourceLocation());
            HELPER_CONTEXT.put(this.getResourceLocation(), ctxt);
        }
        return HELPER_CONTEXT.get(this.getResourceLocation());
    }

    @Override
    public final void load(InputStream _is) throws Exception {
        if (this.object != null) {
            this.object.delete();
            this.object = null;
        }
        try {
            XMLDocument doc = this.getHelperContext().getXMLHelper().load(_is);
            this.object = doc.getRootObject();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new Exception("Could not load DataObject ");
        }
    }

    @Override
    public final void save(File _dest) throws Exception {
        FileUtilities.writeFile(this.toString().getBytes(), _dest.getAbsolutePath());
    }

    @Override
    public final DataObject getDataObject() {
        if (this.object == null) {
            try {
                HelperContext localHc = this.getHelperContext();
                this.object = localHc.getDataFactory().create(this.getNamespace(), this.getXSDType());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.object;
    }

    public final String toString() {
        String result = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            XMLHelper helper = this.getHelperContext().getXMLHelper();
            helper.save(this.getDataObject(), this.getNamespace(), this.getXSDType(), (OutputStream)bos);
            result = new String(bos.toByteArray());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    static {
        HELPER_CONTEXT = new HashMap();
    }
}

