/*
 * Decompiled with CFR 0.152.
 */
package com.aurea.maven.plugins.sonic.topology.utils;

import com.aurea.maven.plugins.sonic.topology.utils.Environment;
import com.aurea.maven.plugins.sonic.topology.utils.MachineHolder;
import com.aurea.maven.plugins.sonic.topology.utils.ParameterHolder;
import java.io.Serializable;
import java.util.SortedSet;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class TopologyHolder
implements Serializable {
    private static final long serialVersionUID = 1L;
    String topologyId;
    String topoEnvId;
    MachineHolder machineHolder;
    Environment env;
    ParameterHolder pholder;

    public TopologyHolder(String topoId) {
        this.topologyId = topoId;
        this.machineHolder = new MachineHolder();
    }

    public String getTopologyId() {
        return this.topologyId;
    }

    public void setTopologyId(String topologyId) {
        this.topologyId = topologyId;
    }

    public String getTopoEnvId() {
        return this.topoEnvId;
    }

    public void setTopoEnvId(String topoEnvId) {
        this.topoEnvId = topoEnvId;
    }

    public MachineHolder getMachineHolder() {
        return this.machineHolder;
    }

    public void setMachineHolder(MachineHolder machineHolder) {
        this.machineHolder = machineHolder;
    }

    public Environment getEnv() {
        return this.env;
    }

    public void setEnv(Environment env) {
        this.env = env;
    }

    public ParameterHolder getPholder() {
        return this.pholder;
    }

    public void setPholder(ParameterHolder pholder) {
        this.pholder = pholder;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\n-------------------------------\n" + this.getTopologyId() + "\n" + this.getTopoEnvId() + "\n");
        for (int i = 0; i < this.getMachineHolder().getMachineConfigs().size(); ++i) {
            sb.append(this.getMachineHolder().getMachineConfigs().get(i).toString());
        }
        sb.append("\n-------------------------------\n");
        sb.append("Environment");
        sb.append(this.env.toString());
        sb.append("\n-------------------------------\n");
        sb.append("Parameters");
        sb.append(this.pholder.toString());
        sb.append("\n-------------------------------\n");
        return sb.toString();
    }

    public String createEnvironmentTopology(TopologyHolder tHolder, SortedSet<String> propNames) {
        Xpp3Dom topology = new Xpp3Dom("Environment");
        Xpp3Dom id = new Xpp3Dom("Id");
        id.setValue(this.getTopologyId());
        topology.addChild(id);
        this.machineHolder.createMachineXmlContent(topology);
        this.env.createEnvironmentXmlContent(topology);
        this.getPholder().createParameterXmlContent(topology, tHolder, propNames);
        return topology.toString();
    }
}

