/*
 * Decompiled with CFR 0.152.
 */
package com.aurea.maven.plugins.sonic.utils;

import com.aurea.maven.plugins.sonic.utils.JavaInvoker;
import com.aurea.maven.plugins.sonic.utils.OffLineDSConfigurator;
import com.sonicsw.mf.jmx.client.JMSConnectorAddress;
import com.sonicsw.mf.jmx.client.JMSConnectorClient;
import com.sonicsw.mf.mgmtapi.runtime.IAgentProxy;
import com.sonicsw.mf.mgmtapi.runtime.IDirectoryServiceProxy;
import com.sonicsw.mf.mgmtapi.runtime.MFProxyFactory;
import com.sonicsw.mf.mgmtapi.runtime.ProxyRuntimeException;
import com.sonicsw.mq.mgmtapi.runtime.IBrokerProxy;
import com.sonicsw.mq.mgmtapi.runtime.MQProxyFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.Hashtable;
import javax.management.ObjectName;

public class SonicInvoker
extends JavaInvoker {
    public SonicInvoker(String _sonicDirectory) throws Exception {
        super("com.sonicsw.mf.framework.agent.ci.LaunchContainer");
        this.setWorkingDir(_sonicDirectory);
        this.configureSonicRuntime();
    }

    public final void configureSonicRuntime() throws Exception {
        File sonicDir = new File(this.getWorkdir());
        this.checkDir(sonicDir);
        File sonicLib = new File(sonicDir, "lib");
        this.checkDir(sonicLib);
        this.addToPatchedModules("java.management", new File(sonicLib, "jmxri.jar").getAbsolutePath());
        this.addToClassPath(new File(sonicLib, "MFLaunch.jar").getAbsolutePath());
        this.addToClassPath(new File(sonicLib, "rsa_ssl.jar").getAbsolutePath());
        this.setProperty("java.protocol.handler.pkgs", "progress.message.net");
        this.setProperty("SSL_CA_CERTIFICATES_DIR", new File(sonicDir, "certs/CA").getAbsolutePath());
        this.setProperty("sonicsw.home", this.getWorkdir());
        this.setProperty("sonicsw.mf.allowRestart", "true");
        this.addArgument("container.xml");
        this.addArgument("ds.xml");
    }

    private void checkDir(File _dir) throws Exception {
        if (!_dir.exists()) {
            throw new Exception("Directory " + _dir.getAbsolutePath() + " does not exist.");
        }
        if (!_dir.isDirectory()) {
            throw new Exception("Directory " + _dir.getAbsolutePath() + " is not a directory.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] _args) {
        try {
            String input;
            System.out.println("Invoking");
            ProcessBuilder process = new ProcessBuilder("C:\\Software\\Sonic7.6\\TestImage\\SonicData\\startCtManagement.bat");
            process.directory(new File("C:\\Software\\Sonic7.6\\TestImage\\SonicData"));
            Process p = process.start();
            BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while (!(input = br.readLine()).toUpperCase().contains("STARTUP COMPLETE")) {
                System.out.println("Sonic: " + input);
            }
            System.out.println("Found: " + input + "\nContinuing");
            System.out.println("Done Invoking");
            br.close();
            System.out.println("Sleeping");
            Thread.sleep(10000L);
            System.out.println("Performing the configuration");
            OffLineDSConfigurator ods = new OffLineDSConfigurator();
            ods.go();
            System.out.println("Sleeping for shutdown");
            Thread.sleep(10000L);
            System.out.println("Shutting Down");
            JMSConnectorClient connector = null;
            try {
                System.out.println("Get Connector");
                connector = SonicInvoker.getConnector("tcp://localhost:3506", "Administrator", "Administrator");
                System.out.println("Agent Proxy");
                IAgentProxy agent = SonicInvoker.getAgentProxy(connector, "Domain1", "ctManagement");
                System.out.println("shutdown");
                agent.shutdown();
                System.out.println("Shutdown Done");
            }
            catch (Throwable t) {
                t.printStackTrace();
                if (t instanceof ProxyRuntimeException) {
                    System.err.println("Caused by:");
                    ((ProxyRuntimeException)t).getTargetException().printStackTrace();
                }
            }
            finally {
                if (connector != null) {
                    connector.disconnect();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static JMSConnectorClient getConnector(String _urls, String _user, String _pwd) throws Exception {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("ConnectionURLs", _urls);
        env.put("DefaultUser", _user);
        env.put("DefaultPassword", _pwd);
        JMSConnectorAddress address = new JMSConnectorAddress(env);
        JMSConnectorClient connector = new JMSConnectorClient();
        connector.connect(address, 10000L);
        return connector;
    }

    public static IAgentProxy getAgentProxy(JMSConnectorClient _connector, String _domain, String _container) throws Exception {
        ObjectName jmxName = new ObjectName(_domain + "." + _container + ":ID=AGENT");
        return MFProxyFactory.createAgentProxy((JMSConnectorClient)_connector, (ObjectName)jmxName);
    }

    public static IDirectoryServiceProxy getDirectoryServiceProxy(JMSConnectorClient _connector, String _domain) throws Exception {
        ObjectName jmxName = new ObjectName(_domain + ".DIRECTORY SERVICE:ID=DIRECTORY SERVICE");
        return MFProxyFactory.createDirectoryServiceProxy((JMSConnectorClient)_connector, (ObjectName)jmxName);
    }

    public static IBrokerProxy getBrokerProxy(JMSConnectorClient _connector, String _domain, String _container, String _id) throws Exception {
        ObjectName jmxName = new ObjectName(_domain + "." + _container + ":ID=" + _id);
        return MQProxyFactory.createBrokerProxy((JMSConnectorClient)_connector, (ObjectName)jmxName);
    }
}

