/*
 * Decompiled with CFR 0.152.
 */
package com.aurea.sonic.esb.annotation.util;

import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public final class ElementUtil {
    private ElementUtil() {
    }

    public static String classToXmlType(Class<?> clazz, boolean isCollection) {
        String xmlType;
        switch (clazz.getName()) {
            case "java.lang.String": {
                xmlType = "xsd:string";
                break;
            }
            case "java.lang.Long": {
                xmlType = "xsd:long";
                break;
            }
            case "java.lang.Integer": {
                xmlType = "xsd:int";
                break;
            }
            case "java.lang.Short": {
                xmlType = "xsd:short";
                break;
            }
            case "java.lang.Boolean": {
                xmlType = "xsd:boolean";
                break;
            }
            case "java.lang.Float": {
                xmlType = "xsd:float";
                break;
            }
            case "java.lang.Double": {
                xmlType = "xsd:double";
                break;
            }
            case "java.lang.Byte": {
                xmlType = isCollection ? "xsd:hexBinary" : "xsd:byte";
                break;
            }
            case "java.math.BigInteger": {
                xmlType = "xsd:integer";
                break;
            }
            case "java.math.BigDecimal": {
                xmlType = "xsd:decimal";
                break;
            }
            case "java.net.URL": {
                xmlType = "xsd:string";
                break;
            }
            case "java.util.UUID": {
                xmlType = "xsd:string";
                break;
            }
            case "java.util.Date": {
                xmlType = "xsd:dateTime";
                break;
            }
            default: {
                xmlType = "xsd:any";
            }
        }
        return xmlType;
    }

    public static Class<?> classFromType(Types types, TypeMirror type) {
        Class javaType;
        if (type.getKind() == TypeKind.VOID) {
            javaType = Void.class;
        } else if (type.getKind() == TypeKind.ARRAY) {
            ArrayType arrayType = (ArrayType)type;
            TypeElement typeElement = ElementUtil.typeElementFromType(types, arrayType.getComponentType());
            javaType = ElementUtil.classFromJavaType(typeElement.getQualifiedName().toString());
        } else {
            TypeElement typeElement = ElementUtil.typeElementFromType(types, type);
            javaType = ElementUtil.classFromJavaType(typeElement.getQualifiedName().toString());
        }
        return javaType;
    }

    public static TypeElement typeElementFromType(Types types, TypeMirror type) {
        TypeElement typeElement;
        if (type.getKind().isPrimitive()) {
            typeElement = types.boxedClass(types.getPrimitiveType(type.getKind()));
        } else if (type.getKind() == TypeKind.DECLARED) {
            DeclaredType returnType = (DeclaredType)type;
            typeElement = (TypeElement)returnType.asElement();
        } else {
            throw new IllegalArgumentException("Invalid type kind " + (Object)((Object)type.getKind()));
        }
        return typeElement;
    }

    public static Class<?> classFromJavaType(String javaType) {
        try {
            return Class.forName(javaType);
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    public static boolean implementsInterface(Types types, Elements elements, TypeMirror type, String interfaceClass) {
        TypeMirror typeOfE = elements.getTypeElement(interfaceClass).asType();
        boolean isSubTypeOfE = types.isSubtype(type, typeOfE);
        return isSubTypeOfE;
    }
}

