// =====================================================================================================================
// Copyright (c) 2016. Aurea Software, Inc. All Rights Reserved.
//
// You are hereby placed on notice that the software, its related technology and services may be covered by one or
// more United States ("US") and non-US patents. A listing that associates patented and patent-pending products
// included in the software, software updates, their related technology and services with one or more patent numbers
// is available for you and the general public's access at www.aurea.com/legal/ (the "Patent Notice") without charge.
// The association of products-to-patent numbers at the Patent Notice may not be an exclusive listing of associations,
// and other unlisted patents or pending patents may also be associated with the products. Likewise, the patents or
// pending patents may also be associated with unlisted products. You agree to regularly review the products-to-patent
// number(s) association at the Patent Notice to check for updates.
// =====================================================================================================================

package com.aurea.sonic.esb.annotation.util;

import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

/**
 * <!-- ========================================================================================================== -->
 * Processor Context of Annotations
 *
 * <!-- --------------------------------------------------------------------------------------------------------- -->
 */
public class ProcessorContext {

	private final Filer filer;
	private final Messager messager;
	private final Types types;
	private final Elements elements;

	/**
	 * Allocates a ProcessorContext with the given {@code processingEnv}
	 *
	 * @param processingEnv processing environment
	 */
	public ProcessorContext(final ProcessingEnvironment processingEnv) {
		this.filer = processingEnv.getFiler();
		this.messager = processingEnv.getMessager();
		this.types = processingEnv.getTypeUtils();
		this.elements = processingEnv.getElementUtils();
	}

	public Filer getFiler() {
		return filer;
	}

	public Messager getMessager() {
		return messager;
	}

	public Types getTypes() {
		return types;
	}

	public Elements getElements() {
		return elements;
	}

}
