/*
 * Decompiled with CFR 0.152.
 */
package com.progress.sonic.esb.camel;

import com.progress.sonic.esb.camel.AsyncResponseHandler;
import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQEndpointCreationException;
import com.sonicsw.xq.XQInitContext;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQParameters;
import com.sonicsw.xq.XQServiceException;
import com.sonicsw.xq.service.asynch.IAXQMessageHandler;
import com.sonicsw.xqimpl.config.IXQConfigManager;
import com.sonicsw.xqimpl.config.XQConfigManager;
import com.sonicsw.xqimpl.config.XQConfigurationException;
import com.sonicsw.xqimpl.config.XQConnectionConfig;
import com.sonicsw.xqimpl.config.XQEndpointConfig;
import com.sonicsw.xqimpl.container.Coordinator;
import com.sonicsw.xqimpl.container.ICorrelatedListener;
import com.sonicsw.xqimpl.container.IRegistration;
import com.sonicsw.xqimpl.endpoint.container.EndpointManager;
import com.sonicsw.xqimpl.envelope.XQAddressImpl;
import com.sonicsw.xqimpl.service.XQContainer;
import com.sonicsw.xqimpl.util.XQParametersImpl;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class DefaultAsyncResponseHandler
implements AsyncResponseHandler {
    private InitialContext context;
    private IXQConfigManager configManager;
    private String tmpEndpointName;
    private XQEndpointConfig endpointConfig;
    private IRegistration endpointReg;
    private String ourServiceName;
    private long startTime;
    private String correlationIdPrefix = "";
    private String tmpEndpointType = "TOPIC";
    private XQLog log;
    private XQInitContext initContext;
    private long sequence;
    private boolean initialized;

    @Override
    public void init(XQInitContext initCtx) throws Exception {
        this.initContext = initCtx;
        this.log = initCtx.getLog();
        if (Boolean.getBoolean("sonic.connect.jndi.lookupEnabled")) {
            this.context = new InitialContext();
        } else if (this.configManager == null) {
            this.configManager = XQConfigManager.getInstance(null);
        }
        XQEndpointConfig originalConfig = this.getEntryEPConfig();
        XQParameters params = this.initContext.getParameters();
        this.ourServiceName = params.getParameter("SonicXQ.ServiceInstanceName", 1);
        this.tmpEndpointName = this.ourServiceName + ".Connect.AsynchTmp";
        if (params.containsParameter("tmpEP", 1)) {
            this.tmpEndpointType = params.getParameter("tmpEP", 1, "TOPIC");
        }
        if (this.log.isDebugLoggingEnabled()) {
            this.log.logDebug("[" + this.ourServiceName + "]: Registering " + " temp destination - " + this.tmpEndpointName + " tmpEndpointType - " + this.tmpEndpointType);
        }
        this.endpointConfig = this.getTempEndpointConfig(originalConfig, this.tmpEndpointName, "AsynchEntry");
        this.endpointReg = Coordinator.getInstance().registerTmpDestination(this.endpointConfig);
        this.startTime = System.currentTimeMillis();
        this.correlationIdPrefix = this.ourServiceName + ":" + Long.toString(this.startTime) + ":";
        this.initialized = true;
    }

    @Override
    public XQMessage[] getResponse() {
        return new XQMessage[0];
    }

    private XQEndpointConfig getTempEndpointConfig(XQEndpointConfig originalConfig, String projectWorklistTopic, String endpointName) throws XQEndpointCreationException {
        XQEndpointConfig config = DefaultAsyncResponseHandler.createTempEndpointConfig(originalConfig, projectWorklistTopic, this.tmpEndpointType);
        return config;
    }

    private static XQEndpointConfig createTempEndpointConfig(XQEndpointConfig originalConfig, String epName, String destinationType) throws XQEndpointCreationException {
        XQEndpointConfig endpointConfig;
        if (originalConfig != null) {
            endpointConfig = (XQEndpointConfig)originalConfig.clone();
            XQParametersImpl params = endpointConfig.getParameters();
            String originalEndpointDestinationType = params.getParameter("type", 1, "TOPIC");
            params.setParameter("destination", 1, epName);
            params.setParameter("type", 1, destinationType);
            params.removeParameter("messageSelector", 1);
            if (destinationType.equals("TOPIC")) {
                params.setParameter("sharedSubscriptions", 1, Boolean.FALSE.toString());
            }
            if ("QUEUE".equals(originalEndpointDestinationType)) {
                params.setParameter("durableSubscriberName", 1, epName);
            }
            endpointConfig.setName(epName);
        } else {
            XQConnectionConfig conConfig = XQContainer.getJMSDefaultConnConfig();
            endpointConfig = EndpointManager.getInstance().createXQEndpointConfig(epName, epName, destinationType, conConfig.getName());
            if (destinationType.equals("TOPIC")) {
                endpointConfig.getParameters().setParameter("sharedSubscriptions", 1, Boolean.FALSE.toString());
            }
        }
        return endpointConfig;
    }

    private XQEndpointConfig getEntryEPConfig() throws XQConfigurationException, XQServiceException, NamingException {
        XQAddress entryEndpoint = this.getEntryEndpoint();
        if (entryEndpoint == null) {
            return null;
        }
        if (Boolean.getBoolean("sonic.connect.jndi.lookupEnabled")) {
            String entryEPName = "endpoint/" + entryEndpoint.getName();
            return (XQEndpointConfig)this.context.lookup(entryEPName);
        }
        return this.configManager.lookupEndpointConfig(entryEndpoint.getName());
    }

    private XQAddress getEntryEndpoint() {
        XQParameters params = this.initContext.getParameters();
        XQAddress entryEndpoint = (XQAddress)params.getParameterObject("SonicXQ.EntryEndpointAddress", 3);
        return entryEndpoint;
    }

    XQAddress getTempAddress() {
        return new XQAddressImpl(this.tmpEndpointName, 0);
    }

    public synchronized String createUniqueCorrelationID() {
        return this.correlationIdPrefix + this.sequence++ + ':';
    }

    public void registerMessageHandler(String correlationId, IAXQMessageHandler asyncMessageHandler) {
        this.endpointReg.registerMessageHandler((Object)correlationId, (ICorrelatedListener)asyncMessageHandler);
    }

    public void unRegisterMessageHandler(String correlationId) {
        this.endpointReg.unRegisterMessageHandler((Object)correlationId);
    }

    public short getResultStatus(IAXQMessageHandler amh) {
        short rc = amh.isComplete() ? (short)1 : -1;
        return rc;
    }

    @Override
    public String getServiceName() {
        return this.ourServiceName;
    }

    @Override
    public boolean hasBeenInitialized() {
        return this.initialized;
    }

    @Override
    public void setXqConfigManager(IXQConfigManager xqConfigManager) {
        this.configManager = xqConfigManager;
    }
}

