/*
 * Decompiled with CFR 0.152.
 */
package com.progress.sonic.esb.camel;

import com.progress.sonic.esb.camel.RecipientHandler;
import com.progress.sonic.esb.camel.util.URITemplateHolder;
import com.progress.sonic.esb.camel.util.URLTemplateUtils;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.ToDefinition;
import org.apache.cxf.jaxrs.impl.MetadataMap;

public class SonicEsbRecipientHandler
implements RecipientHandler {
    private CamelContext camelContext;
    private Map<String, List<URITemplateHolder>> jettyTemplateCache = new HashMap<String, List<URITemplateHolder>>();

    public void setCamelContext(CamelContext context) {
        this.camelContext = context;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setRecipientHeaders(Map<String, Object> headers, String recipientUri) throws Exception {
        String destAndPath;
        URI uri = new URI(recipientUri);
        String httpPathOnly = destAndPath = uri.getPath();
        String sonicPathOnly = destAndPath;
        if (destAndPath.lastIndexOf(47) > 0) {
            httpPathOnly = destAndPath.substring(destAndPath.indexOf(47, 1));
            sonicPathOnly = destAndPath.substring(0, destAndPath.indexOf(47, 1));
        }
        String pathAndQuery = httpPathOnly;
        headers.put("CamelHttpPath", httpPathOnly);
        headers.put("CamelHttpUrl", "sonicesb://" + uri.getHost() + sonicPathOnly);
        headers.put("CamelHttpBaseUri", "");
        String queryString = URLTemplateUtils.extractQueryString(recipientUri);
        if (queryString != null && queryString.length() > 0) {
            headers.put("CamelHttpQuery", queryString);
            pathAndQuery = httpPathOnly + "?" + queryString;
        }
        MetadataMap templateValues = new MetadataMap();
        List<URITemplateHolder> templates = this.getJettyFeederRouteTemplates(uri.getHost() + sonicPathOnly);
        int bestIdx = URLTemplateUtils.bestTemplateMatch(templates, (MultivaluedMap<String, String>)templateValues, pathAndQuery);
        if (bestIdx != -1) {
            String key22 = null;
            for (String key22 : templateValues.keySet()) {
                String string = (String)templateValues.getFirst((Object)key22);
                headers.put(key22, string);
            }
            headers.put("URITemplate", templates.get(bestIdx).getTemplate().getValue());
        }
        Map<String, String> queryMap = URLTemplateUtils.extractQueryMap(pathAndQuery);
        for (Map.Entry entry : queryMap.entrySet()) {
            headers.put((String)entry.getKey(), entry.getValue());
        }
        headers.put("RecipientOverride", "sonicesb://" + uri.getHost() + sonicPathOnly);
    }

    private List<URITemplateHolder> getJettyFeederRouteTemplates(String sonicPathOnly) throws Exception {
        if (this.jettyTemplateCache.get(sonicPathOnly) != null) {
            return this.jettyTemplateCache.get(sonicPathOnly);
        }
        ArrayList<URITemplateHolder> utemplates = new ArrayList<URITemplateHolder>();
        if (this.camelContext != null) {
            ModelCamelContext model = (ModelCamelContext)this.camelContext;
            List routes = model.getRouteDefinitions();
            for (RouteDefinition route : routes) {
                if (!this.isJettyFeeder(route, sonicPathOnly)) continue;
                utemplates.add(this.extractTemplate(route));
            }
        }
        this.jettyTemplateCache.put(sonicPathOnly, utemplates);
        return utemplates;
    }

    private boolean isJettyFeeder(RouteDefinition route, String sonicPathOnly) {
        if (route.getInputs() == null || route.getOutputs() == null) {
            return false;
        }
        if (route.getInputs().size() != 1 || route.getOutputs().size() != 1) {
            return false;
        }
        if (route.getInputs().size() > 0 && ((FromDefinition)route.getInputs().get(0)).getUri() != null && ((FromDefinition)route.getInputs().get(0)).getUri().startsWith("cxfjetty:")) {
            return false;
        }
        ProcessorDefinition processor = (ProcessorDefinition)route.getOutputs().get(0);
        if (!(processor instanceof ToDefinition)) {
            return false;
        }
        ToDefinition todef = (ToDefinition)processor;
        return todef.getEndpoint().getEndpointUri().equalsIgnoreCase(sonicPathOnly);
    }

    private URITemplateHolder extractTemplate(RouteDefinition route) throws Exception {
        Endpoint jep = ((FromDefinition)route.getInputs().get(0)).getEndpoint();
        Method mth = jep.getClass().getMethod("getTemplate", new Class[0]);
        return new URITemplateHolder((String)mth.invoke((Object)jep, new Object[0]));
    }
}

