/*
 * Decompiled with CFR 0.152.
 */
package com.progress.sonic.esb.camel.util;

import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQMessageException;
import com.sonicsw.xqimpl.util.DOMUtils;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.camel.Exchange;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.binding.soap.SoapHeader;
import org.apache.cxf.headers.Header;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class HeaderUtils {
    private static final transient Log LOG = LogFactory.getLog(HeaderUtils.class);
    private static Transformer transformer;

    private HeaderUtils() {
    }

    public static Transformer getTransformer() throws TransformerException {
        if (transformer == null) {
            transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
        }
        return transformer;
    }

    public static void propagateHeadersFromXQMessage(XQMessage message, Map<String, Object> camelHeaders, Exchange exchange, HeaderFilterStrategy headerFilterStrategy, Map<String, String> xqToCamelHeaderMap) throws XQMessageException {
        Iterator iter = message.getHeaderNames();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            Object value = message.getHeaderValue(key);
            if (headerFilterStrategy != null && headerFilterStrategy.applyFilterToExternalHeaders(key, value, exchange)) {
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace((Object)("Drop external header " + key + "=" + value));
                continue;
            }
            String mappedHeaderName = null;
            if (xqToCamelHeaderMap != null) {
                mappedHeaderName = xqToCamelHeaderMap.get(key);
            }
            if (mappedHeaderName == null) {
                mappedHeaderName = key;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Populate external header " + key + "=" + value + " as " + mappedHeaderName));
            }
            camelHeaders.put(mappedHeaderName, value);
        }
    }

    public static void propagateHeadersFromCamel(Map<String, Object> headers, Exchange exchange, XQMessage xqMessage, HeaderFilterStrategy headerFilterStrategy, Map<String, String> camelToXqHeaderMap) throws XQMessageException {
        for (Map.Entry<String, Object> entry : headers.entrySet()) {
            String entryKey = entry.getKey();
            Object entryValue = entry.getValue();
            if (headerFilterStrategy != null && headerFilterStrategy.applyFilterToCamelHeaders(entryKey, entryValue, exchange)) {
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace((Object)("Drop Camel header: " + entryKey + "=" + entryValue));
                continue;
            }
            if (Header.HEADER_LIST.equals(entryKey)) {
                if (!(entryValue instanceof List)) continue;
                for (Object item : ((List)entryValue).toArray()) {
                    if (!(item instanceof SoapHeader)) continue;
                    QName key = ((SoapHeader)item).getName();
                    Object value = ((SoapHeader)item).getObject();
                    String extractedValue = HeaderUtils.elementToString(value);
                    if (extractedValue != null && !extractedValue.trim().isEmpty()) {
                        HeaderUtils.setHeader(camelToXqHeaderMap, key.toString(), extractedValue, xqMessage);
                        continue;
                    }
                    extractedValue = HeaderUtils.elementAsString(value, key.toString());
                    HeaderUtils.setHeader(camelToXqHeaderMap, key.toString(), extractedValue, xqMessage);
                }
                continue;
            }
            HeaderUtils.setHeader(camelToXqHeaderMap, entryKey, entryValue, xqMessage);
        }
    }

    private static synchronized String elementAsString(Object element, String name) throws XQMessageException {
        try {
            StringWriter writer = new StringWriter();
            HeaderUtils.getTransformer().transform(new DOMSource((Node)element), new StreamResult(writer));
            return writer.toString();
        }
        catch (TransformerException e) {
            throw new XQMessageException("Cannot convert header " + name + " value to string");
        }
    }

    private static void setHeader(Map<String, String> camelToXqHeaderMap, String entryKey, Object entryValue, XQMessage xqMessage) throws XQMessageException {
        String mappedHeaderName = null;
        if (camelToXqHeaderMap != null) {
            mappedHeaderName = camelToXqHeaderMap.get(entryKey);
        }
        if (mappedHeaderName == null) {
            mappedHeaderName = entryKey;
        }
        if (!"ResponseContext".equals(mappedHeaderName)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Propagate Camel header: " + entryKey + "=" + entryValue + " as " + mappedHeaderName));
            }
            Object value = entryValue == null ? null : HeaderUtils.toJMSPropertyObject(entryValue);
            xqMessage.setHeaderValue(mappedHeaderName, value);
        }
    }

    public static String elementToString(Object element) {
        return DOMUtils.getFirstTextChildValue((Element)((Element)element));
    }

    private static Object toJMSPropertyObject(Object value) {
        if (value.getClass().isPrimitive()) {
            return value.toString();
        }
        return value;
    }
}

