/*
 * Decompiled with CFR 0.152.
 */
package com.progress.sonic.esb.camel;

import com.progress.sonic.esb.camel.CxfrsNoQueryMapRecipientHandler;
import com.progress.sonic.esb.camel.CxfrsRecipientHandler;
import com.progress.sonic.esb.camel.RecipientHandler;
import com.progress.sonic.esb.camel.RestBindingStrategy;
import com.progress.sonic.esb.camel.util.EsbUtils;
import com.sonicsw.esb.process.mapping.ParameterValueMap;
import com.sonicsw.xq.XQMessage;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.util.ObjectHelper;

public class GenericRestInvocationBindingStrategy
extends RestBindingStrategy {
    private Map<String, RecipientHandler> recipientHandlers = new HashMap<String, RecipientHandler>();
    private RecipientHandler defaultRecipentHandler;

    @Override
    public Map<String, Object> bindRequestHeadersFromXQMessage(XQMessage message, Exchange exchange) throws Exception {
        ParameterValueMap pvm = EsbUtils.getInputParamValueMap(exchange);
        HashMap<String, Object> answer = new HashMap<String, Object>();
        String method = EsbUtils.getStringFromParamMap(pvm, message, "Method");
        ObjectHelper.notNull((Object)method, (String)"Message mapping input parameter 'Method'");
        String accept = EsbUtils.getStringFromParamMap(pvm, message, "Accept");
        if ("GET".equalsIgnoreCase(method)) {
            ObjectHelper.notNull((Object)accept, (String)"Message mapping input parameter 'Accept'");
        }
        String url = EsbUtils.getStringFromParamMap(pvm, message, "URL");
        ObjectHelper.notNull((Object)url, (String)"Message mapping input parameter 'URL'");
        String contentType = EsbUtils.getStringFromParamMap(pvm, message, "ContentType");
        if (contentType == null) {
            contentType = this.deriveRequestContentType(message, method);
        }
        this.setHttpRequestHeaders(answer, method, accept, contentType, url);
        this.setRecipentHeaders(answer, url, exchange);
        this.applyGeneralBindRequestHeaderRules(answer, message, exchange);
        return answer;
    }

    public void setRecipientHandlers(Map<String, RecipientHandler> recipientHandlers) {
        this.recipientHandlers = recipientHandlers;
    }

    public Map<String, RecipientHandler> getRecipientHandlers() {
        return this.recipientHandlers;
    }

    public RecipientHandler getDefaultRecipentHandler() {
        return this.defaultRecipentHandler;
    }

    public void setDefaultRecipentHandler(RecipientHandler defaultRecipentHandler) {
        this.defaultRecipentHandler = defaultRecipentHandler;
    }

    private void setRecipentHeaders(Map<String, Object> headers, String recipientUri, Exchange exchange) throws Exception {
        String scheme = new URI(recipientUri).getScheme();
        RecipientHandler recipientHandler = this.recipientHandlers.get(scheme);
        if (recipientHandler != null) {
            recipientHandler.setRecipientHeaders(headers, recipientUri);
            this.dealWithMVHeaderBindingStrategyDefinition(exchange, recipientHandler, headers, recipientUri);
        } else if (this.defaultRecipentHandler != null) {
            this.defaultRecipentHandler.setRecipientHeaders(headers, recipientUri);
            this.dealWithMVHeaderBindingStrategyDefinition(exchange, recipientHandler, headers, recipientUri);
        }
    }

    private void dealWithMVHeaderBindingStrategyDefinition(Exchange exchange, RecipientHandler recipientHandler, Map<String, Object> headers, String originalUri) {
        if ((recipientHandler instanceof CxfrsRecipientHandler || recipientHandler instanceof CxfrsNoQueryMapRecipientHandler) && exchange.getContext().getRegistry().lookup("GlobalGenericRestInvocationCxfRsBindingStrategy") == null && ((String)headers.get("RecipientOverride")).contains("?binding=#GlobalGenericRestInvocationCxfRsBindingStrategy")) {
            headers.put("RecipientOverride", "cxfrs://" + originalUri);
        }
    }
}

