/*
 * Decompiled with CFR 0.152.
 */
package com.progress.sonic.esb.camel;

import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQAddressFactory;
import com.sonicsw.xq.XQAddressNotFoundException;
import com.sonicsw.xqimpl.common.XQAbstractAddressImpl;
import org.apache.camel.Endpoint;

public class SonicEsbURI {
    public static final String SONIC_URL_SCHEMA = "sonicesb";
    public static final String SONIC_URL_LOCAL_PREFIX = "sonicesb://";
    private XQAddress sonicAddress;

    public SonicEsbURI(Endpoint esbEndpoint, XQAddressFactory addrFactory) {
        this.computeAddress(esbEndpoint, addrFactory);
    }

    private void computeAddress(Endpoint esbEndpoint, XQAddressFactory addrFactory) {
        String urlString = esbEndpoint.getEndpointUri();
        assert (urlString != null);
        String[] addressParts = urlString.split("/");
        if (addressParts.length != 2) {
            SonicEsbURI.throwException(urlString);
        }
        int addressType = -1;
        try {
            addressType = XQAbstractAddressImpl.getTypeAsInt((String)addressParts[0].toUpperCase());
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (addressType != 1 && addressType != 2) {
            SonicEsbURI.throwException(urlString);
        }
        try {
            this.sonicAddress = addrFactory.createAddress(addressParts[1], addressType);
        }
        catch (XQAddressNotFoundException e) {
            throw new IllegalArgumentException(urlString + " is not a valid ESB configuration", e);
        }
    }

    private static void throwException(String addressStr) {
        throw new IllegalArgumentException(SONIC_URL_LOCAL_PREFIX + addressStr + " is invalid. " + "The right format is  sonicesb://<Type>/<Artifact>" + "<Type> is Service or Process. " + "<Artifact> is the name of the ESB service or process.");
    }

    public XQAddress getXQAddress() {
        return this.sonicAddress;
    }
}

