/*
 * Decompiled with CFR 0.152.
 */
package com.progress.sonic.esb.camel.converter;

import com.progress.sonic.esb.camel.BindingRuleBean;
import com.progress.sonic.esb.camel.BindingRules;
import com.progress.sonic.esb.camel.BindingStrategy;
import com.progress.sonic.esb.camel.SonicEsbConstants;
import com.progress.sonic.esb.camel.util.EsbUtils;
import com.progress.sonic.esb.service.connect.camel_sonicesb.BindingRule;
import com.progress.sonic.esb.service.connect.camel_sonicesb.LocationValueType;
import com.sonicsw.esb.process.mapping.InvocationContext;
import com.sonicsw.esb.process.mapping.ParameterValue;
import com.sonicsw.esb.process.mapping.ParameterValueMap;
import com.sonicsw.xq.XQEnvelope;
import com.sonicsw.xq.XQInitContext;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQMessageException;
import com.sonicsw.xq.XQPart;
import com.sonicsw.xq.XQServiceContext;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.cxf.CxfPayload;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapHeader;
import org.apache.cxf.headers.Header;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.helpers.XMLUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.service.model.BindingFaultInfo;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

@Converter
public final class XQMessageConverter {
    private static final transient Log LOG = LogFactory.getLog(XQMessageConverter.class);
    private static ThreadLocal<SoftReference<DocumentBuilder>> threadLocalDocBuilder = new ThreadLocal();

    private XQMessageConverter() {
    }

    @Converter
    public static XQMessage toXQMessage(Fault fault, Exchange exchange) throws Exception {
        XQServiceContext serviceContext = EsbUtils.getServiceContext(exchange);
        XQMessage message = XQMessageConverter.constructXQMessage(exchange, serviceContext, true);
        Map<String, Element> faultParts = XQMessageConverter.getFaultParts(fault);
        String faultName = null;
        BindingOperationInfo boi = EsbUtils.getBindingOperationInfo(exchange);
        if (boi != null) {
            BindingFaultInfo faultInfo = XQMessageConverter.findFaultInfo(faultParts, boi);
            if (faultInfo != null) {
                faultName = XQMessageConverter.addFaultDetail(faultInfo, serviceContext, faultParts, message);
            } else {
                faultName = "SOAP.Fault";
                XQMessageConverter.addFaultDetail(serviceContext, faultParts, message);
            }
        }
        XQMessageConverter.setFaultHeaders(faultName, fault, message);
        return message;
    }

    private static void addFaultDetail(XQServiceContext serviceContext, Map<String, Element> faultParts, XQMessage message) throws XQMessageException {
        for (Map.Entry<String, Element> entry : faultParts.entrySet()) {
            String partName = "Fault.Detail." + entry.getKey();
            if (message.doesPartExist(partName)) {
                message.removePart(partName);
            }
            XQPart part = message.createPart((Object)XMLUtils.toString((Node)entry.getValue()), "text/xml");
            part.setContentId(partName);
            message.addPart(part);
        }
    }

    private static String addFaultDetail(BindingFaultInfo faultInfo, XQServiceContext serviceContext, Map<String, Element> faultParts, XQMessage message) throws Exception {
        String faultName = faultInfo.getFaultInfo().getFaultName().getLocalPart();
        ParameterValueMap pvm = XQMessageConverter.getFaultParameterValueMap(serviceContext, faultName);
        for (Map.Entry<String, Element> entry : faultParts.entrySet()) {
            ParameterValue value;
            String partName = XQMessageConverter.getPartName(faultInfo, entry.getKey());
            if (partName == null) continue;
            if (pvm != null && (value = pvm.getParameterValue(partName)) != null) {
                value.setValue((Object)XMLUtils.toString((Node)entry.getValue()));
                continue;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("No mapping for param: " + partName));
            }
            if (message.doesPartExist(partName)) {
                message.removePart(partName);
            }
            XQPart part = message.createPart((Object)XMLUtils.toString((Node)entry.getValue()), "text/xml");
            part.setContentId(partName);
            message.addPart(part);
        }
        return faultName;
    }

    private static String getPartName(BindingFaultInfo faultInfo, String key) {
        for (MessagePartInfo partInfo : faultInfo.getFaultInfo().getMessageParts()) {
            if (!partInfo.getConcreteName().getLocalPart().equals(key)) continue;
            return partInfo.getName().getLocalPart();
        }
        return null;
    }

    @Converter
    public static XQMessage toXQMessage(SoapFault fault, Exchange exchange) throws Exception {
        XQMessage answer = XQMessageConverter.toXQMessage((Fault)fault, exchange);
        if (fault.getRole() != null) {
            answer.setStringHeader("SOAP.FaultActor", fault.getRole());
        }
        if (fault.getSubCode() != null) {
            answer.setStringHeader("SonicESB.Fault.SubCode", fault.getSubCode().toString());
        }
        return answer;
    }

    @Converter
    public static XQMessage toXQMessage(Exception ex, Exchange exchange) throws Exception {
        XQServiceContext serviceContext = EsbUtils.getServiceContext(exchange);
        XQMessage message = XQMessageConverter.constructXQMessage(exchange, serviceContext, true);
        String string = ex.getCause() != null ? ex.getCause().toString() : ex.getMessage();
        message.setStringHeader("SonicESB.Fault.String", string);
        message.setStringHeader("SonicESB.Fault.Name", "SonicESB.Connect.Fault");
        return message;
    }

    private static void setFaultHeaders(String faultName, Fault fault, XQMessage message) throws Exception {
        if (fault.getMessage() != null) {
            String string = fault.getCause() != null ? fault.getCause().toString() : fault.getMessage();
            message.setStringHeader("SonicESB.Fault.String", string);
        }
        if (fault.getFaultCode() != null) {
            message.setStringHeader("SonicESB.Fault.Code", fault.getFaultCode().toString());
        }
        message.setStringHeader("SonicESB.Fault.Name", faultName != null ? faultName : "SonicESB.Connect.Fault");
    }

    private static ParameterValueMap getFaultParameterValueMap(XQServiceContext sc, String faultName) {
        InvocationContext invocationContext;
        ParameterValueMap answer = null;
        if (sc != null && (invocationContext = (InvocationContext)sc.getInvocationContext()) != null) {
            answer = invocationContext.getFaultParameterValues(faultName);
        }
        return answer;
    }

    private static BindingFaultInfo findFaultInfo(Map<String, Element> faultParts, BindingOperationInfo boi) throws Exception {
        BindingFaultInfo answer = null;
        for (BindingFaultInfo faultInfo : boi.getFaults()) {
            if (faultInfo.getFaultInfo().getMessageParts().size() != faultParts.size()) continue;
            boolean failedToMatch = false;
            for (MessagePartInfo part : faultInfo.getFaultInfo().getMessageParts()) {
                String concreteName = part.getConcreteName().getLocalPart();
                if (faultParts.get(concreteName) != null) continue;
                failedToMatch = true;
                break;
            }
            if (failedToMatch) continue;
            answer = faultInfo;
            break;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("fault name  = " + (answer == null ? "unknown" : answer.getFaultInfo().getFaultName().getLocalPart())));
        }
        return answer;
    }

    private static Map<String, Element> getFaultParts(Fault fault) throws Exception {
        HashMap<String, Element> answer = new HashMap<String, Element>();
        if (fault.getDetail() != null) {
            NodeList children = fault.getDetail().getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (child.getNodeType() != 1) continue;
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Fault part: " + child.getLocalName() + " = " + XQMessageConverter.toString((Element)child)));
                }
                answer.put(child.getLocalName(), (Element)child);
            }
        }
        return answer;
    }

    @Converter
    public static XQMessage toXQMessage(String payload, Exchange exchange) throws Exception {
        XQServiceContext serviceContext = EsbUtils.getServiceContext(exchange);
        XQMessage message = XQMessageConverter.constructXQMessage(exchange, serviceContext, false);
        if (payload == null || payload.length() == 0) {
            return message;
        }
        String contentType = (String)exchange.getOut().getHeader("Content-Type");
        if (contentType == null) {
            contentType = "text/xml";
        }
        XQPart part = message.createPart((Object)payload, contentType);
        part.setContentId("PostData");
        message.addPart(part);
        return message;
    }

    @Converter
    public static XQMessage toXQMessage(CxfPayload<SoapHeader> cxfPayload, Exchange exchange) throws Exception {
        try {
            if (exchange.isFailed() && exchange.getException() != null) {
                block6: {
                    TypeConverterRegistry registry = exchange.getContext().getTypeConverterRegistry();
                    TypeConverter tc = registry.lookup(XQMessage.class, exchange.getException().getClass());
                    if (tc != null) {
                        try {
                            return (XQMessage)tc.convertTo(XQMessage.class, exchange, (Object)exchange.getException());
                        }
                        catch (Exception e) {
                            if (!LOG.isDebugEnabled()) break block6;
                            LOG.debug((Object)e);
                        }
                    }
                }
                throw new Exception("failed to convert from an Exception '" + exchange.getException().toString() + " to XQMessage");
            }
            return XQMessageConverter.convertFromCxfPayloadToXq(cxfPayload, exchange);
        }
        catch (Exception e) {
            LOG.error((Object)e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Converter
    public static CxfPayload<SoapHeader> toCxfPayLoad(XQMessage message, Exchange exchange) throws Exception {
        try {
            return XQMessageConverter.convertFromXqToCxfPayload(message, exchange);
        }
        catch (Exception e) {
            LOG.error((Object)e.toString(), (Throwable)e);
            throw e;
        }
    }

    private static Element findSoapHeader(List<SoapHeader> headers, QName concreteName) {
        Element answer = null;
        for (SoapHeader soapHeader : headers) {
            if (!soapHeader.getName().equals(concreteName)) continue;
            answer = (Element)soapHeader.getObject();
            break;
        }
        return answer;
    }

    private static CxfPayload<SoapHeader> convertFromXqToCxfPayload(XQMessage message, Exchange exchange) throws XQMessageException {
        XQServiceContext serviceContext = EsbUtils.getServiceContext(exchange);
        TypeConverterRegistry registry = exchange.getContext().getTypeConverterRegistry();
        BindingOperationInfo boi = EsbUtils.getBindingOperationInfo(exchange);
        ArrayList elements = new ArrayList();
        ArrayList<SoapHeader> headers = new ArrayList<SoapHeader>();
        SoapFault fault = XQMessageConverter.checkForFault(boi, message, exchange, registry, serviceContext);
        if (fault != null) {
            exchange.setException((Throwable)fault);
            return new CxfPayload(headers, elements);
        }
        if (boi != null) {
            Message camelMessage;
            boolean isRequest = XQMessageConverter.isARequest(exchange);
            BindingMessageInfo msgInfo = isRequest ? boi.getInput() : boi.getOutput();
            ParameterValueMap params = XQMessageConverter.getParameterValueMap(serviceContext, isRequest);
            List<BindingRuleBean> bindingRules = XQMessageConverter.getBindingRules(isRequest, exchange);
            for (MessagePartInfo p : msgInfo.getMessageInfo().getMessageParts()) {
                ParameterValue value;
                Object content = null;
                String partName = XQMessageConverter.getPartName(p);
                if (bindingRules != null) {
                    content = XQMessageConverter.applyBindingRuleToCamelBody(bindingRules, message, partName, serviceContext);
                }
                if (content == null && params != null && (value = params.getParameterValue(partName)) != null) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Match Camel message with " + (isRequest ? "IN" : "OUT") + " parameter '" + partName + "'"));
                    }
                    content = value.getValue();
                }
                if (content == null) {
                    XQPart part = message.getPart(partName);
                    if (part == null) continue;
                    if ("text/xml".equalsIgnoreCase(part.getContentType()) || "text/plain".equalsIgnoreCase(part.getContentType())) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace((Object)("Assign Camel message with " + (isRequest ? "request" : "response") + " XQ Message part '" + partName + "',  content-type = " + part.getContentType()));
                        }
                        content = part.getContent();
                    }
                }
                if (content != null) {
                    content = XQMessageConverter.convertToElement(content, registry);
                }
                if (content == null) continue;
                if (XQMessageConverter.isASoapMessagePart(msgInfo, partName)) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Set CXF SOAP body with " + (isRequest ? "request" : "response") + " part '" + partName + "'"));
                    }
                    elements.add(Element.class.cast(content));
                    continue;
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Set CXF SOAP header '" + p.getConcreteName() + "' with " + (isRequest ? "request" : "response") + " part '" + partName + "'"));
                }
                headers.add(new SoapHeader(p.getConcreteName(), Element.class.cast(content)));
            }
            Message message2 = camelMessage = isRequest ? exchange.getIn() : exchange.getOut();
            if (camelMessage != null && camelMessage.getHeader(Header.HEADER_LIST) != null) {
                List list = (List)camelMessage.getHeader(Header.HEADER_LIST);
                if (LOG.isTraceEnabled()) {
                    for (SoapHeader h : list) {
                        LOG.trace((Object)("Set CXF SOAP " + (isRequest ? "request" : "response") + " header '" + h.getName() + "'"));
                    }
                }
                headers.addAll(list);
            }
        }
        return new CxfPayload(headers, elements);
    }

    private static Element convertToElement(Object content, TypeConverterRegistry registry) {
        TypeConverter tc;
        Element answer = null;
        answer = !(content instanceof Element) ? ((tc = registry.lookup(Element.class, content.getClass())) != null ? (Element)tc.convertTo(Element.class, content) : null) : (Element)content;
        return answer;
    }

    private static SoapFault checkForFault(BindingOperationInfo boi, XQMessage message, Exchange exchange, TypeConverterRegistry registry, XQServiceContext serviceContext) throws XQMessageException {
        SoapFault answer = null;
        if (XQMessageConverter.isARequest(exchange)) {
            return answer;
        }
        if (EsbUtils.isRME(message)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"XQMessage is a RME");
            }
            answer = new SoapFault("RME.  Please see detail in the container log", SonicEsbConstants.RME_FAULT_CODE);
        } else if (message.containsHeader("SonicESB.Fault.Name")) {
            answer = XQMessageConverter.checkApplicationFault(message.getStringHeader("SonicESB.Fault.Name"), message, boi, exchange, registry, serviceContext);
        }
        return answer;
    }

    private static SoapFault checkApplicationFault(String faultName, XQMessage message, BindingOperationInfo boi, Exchange exchange, TypeConverterRegistry registry, XQServiceContext serviceContext) throws XQMessageException {
        QName faultSubCode;
        QName faultCode;
        String faultString;
        Element detail;
        block15: {
            block14: {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Try to find fault info for fault name: " + faultName));
                }
                BindingFaultInfo faultInfo = null;
                for (BindingFaultInfo info : boi.getFaults()) {
                    if (!info.getFaultInfo().getFaultName().getLocalPart().equals(faultName)) continue;
                    faultInfo = info;
                    break;
                }
                detail = null;
                if (faultInfo != null && faultInfo.getFaultInfo().getMessageParts().size() > 0) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Found fault info for '" + faultName + "' which has " + faultInfo.getFaultInfo().getMessageParts().size() + " message parts"));
                    }
                    ParameterValueMap pvm = XQMessageConverter.getFaultParameterValueMap(serviceContext, faultName);
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("ParameterValueMap is " + pvm));
                    }
                    detail = XQMessageConverter.getDetail(faultInfo, pvm, message, registry);
                }
                faultString = message.containsHeader("SonicESB.Fault.String") ? message.getStringHeader("SonicESB.Fault.String") : "Unknown application fault";
                faultCode = null;
                if (message.containsHeader("SonicESB.Fault.Code")) {
                    try {
                        faultCode = QName.valueOf(message.getStringHeader("SonicESB.Fault.Code"));
                    }
                    catch (Exception e) {
                        if (!LOG.isDebugEnabled()) break block14;
                        LOG.debug((Object)("Fault code '" + message.getStringHeader("SonicESB.Fault.Code") + "' is not a valid QName"), (Throwable)e);
                    }
                }
            }
            faultSubCode = null;
            if (message.containsHeader("SonicESB.Fault.SubCode")) {
                try {
                    faultSubCode = QName.valueOf(message.getStringHeader("SonicESB.Fault.SubCode"));
                }
                catch (Exception e) {
                    if (!LOG.isDebugEnabled()) break block15;
                    LOG.debug((Object)("Fault subcode '" + message.getStringHeader("SonicESB.Fault.SubCode") + "' is not a valid QName"), (Throwable)e);
                }
            }
        }
        SoapFault answer = new SoapFault(faultString, faultCode != null ? faultCode : SonicEsbConstants.APP_FAULT_CODE);
        if (faultSubCode != null) {
            answer.setSubCode(faultSubCode);
        }
        if (detail != null) {
            answer.setDetail(detail);
        }
        if (message.containsHeader("SOAP.FaultActor")) {
            answer.setRole(message.getStringHeader("SOAP.FaultActor"));
        }
        return answer;
    }

    private static Element getDetail(BindingFaultInfo info, ParameterValueMap pvm, XQMessage message, TypeConverterRegistry registry) throws XQMessageException {
        StringBuffer detailStringBuf = new StringBuffer("<detail>");
        for (MessagePartInfo partInfo : info.getFaultInfo().getMessageParts()) {
            ParameterValue value;
            String partName = XQMessageConverter.getPartName(partInfo);
            Object content = null;
            if (pvm != null && (value = pvm.getParameterValue(partName)) != null) {
                content = value.getValue();
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Map parameter: " + partName));
                }
            }
            if (content == null && message.doesPartExist(partName)) {
                content = message.getPart(partName).getContent();
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Get from message part: " + partName));
                }
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Detail part '" + partName + "' gets value '" + content + "'"));
            }
            if (content == null) continue;
            detailStringBuf.append(XQMessageConverter.stripXmlDecl(XQMessageConverter.convertToString(content, registry)));
        }
        detailStringBuf.append("</detail>");
        return XQMessageConverter.toElement(detailStringBuf.toString());
    }

    public static String stripXmlDecl(String input) throws XQMessageException {
        Element element = XQMessageConverter.toElement(input);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XMLUtils.writeTo((Source)new DOMSource(element), (OutputStream)baos, (int)-1, (String)"", (String)"yes");
        return baos.toString();
    }

    private static String convertToString(Object content, TypeConverterRegistry registry) {
        String answer = "";
        if (content == null) {
            return answer;
        }
        if (!(content instanceof String)) {
            TypeConverter tc = registry.lookup(Element.class, content.getClass());
            if (tc != null) {
                try {
                    answer = (String)tc.convertTo(String.class, content);
                }
                catch (Exception e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)e);
                    }
                }
            }
        } else {
            return (String)content;
        }
        return answer;
    }

    public static void applyBindingRuleToSoapHeader(List<BindingRuleBean> bindingRules, List<SoapHeader> headers, XQMessage message, XQServiceContext serviceContext, TypeConverterRegistry registry) throws Exception {
        for (BindingRuleBean bean : bindingRules) {
            Object obj;
            BindingRule rule = bean.getBindingRule();
            if (rule.getTo().getValueType() != LocationValueType.CAMEL_BINDING_HEADER || rule.getFrom().getValueType() != LocationValueType.EXPRESSION) continue;
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Set CXF SOAP request header '" + rule.getFrom().getValue() + "' with expression '" + rule.getFrom().getValue()));
            }
            if ((obj = EsbUtils.evaluate(rule.getFrom().getValue(), message, serviceContext)) != null && !(obj instanceof Element)) {
                TypeConverter tc = registry.lookup(Element.class, obj.getClass());
                obj = tc != null ? tc.convertTo(Element.class, obj) : null;
            }
            if (obj == null) continue;
            Element elem = (Element)Element.class.cast(obj);
            QName name = null;
            name = rule.getTo().getValue() != null ? QName.valueOf(rule.getTo().getValue()) : QName.valueOf(elem.getNamespaceURI() + elem.getLocalName());
            headers.add(new SoapHeader(name, (Object)elem));
        }
    }

    @Converter
    public static XQMessage toXQMessage(Response response, Exchange exchange) throws Exception {
        XQMessage message = null;
        XQServiceContext serviceContext = EsbUtils.getServiceContext(exchange);
        if (serviceContext != null) {
            XQEnvelope envelope = serviceContext.getFirstIncoming();
            message = envelope.getMessage();
        } else {
            XQInitContext initContext = (XQInitContext)exchange.getProperty(XQInitContext.class.getName(), XQInitContext.class);
            ObjectHelper.notNull((Object)initContext, (String)XQInitContext.class.getName());
            message = initContext.getMessageFactory().createMessage();
        }
        if (serviceContext != null && serviceContext.getInvocationContext() != null) {
            String content;
            ParameterValueMap params = ((InvocationContext)serviceContext.getInvocationContext()).getOutputParameterValues();
            ObjectHelper.notNull((Object)params, (String)"outputParams");
            ParameterValue value = params.getParameterValue("Response");
            ObjectHelper.notNull((Object)value, (String)"Response");
            Object obj = response.getEntity();
            if (obj == null) {
                return null;
            }
            InputStream is = null;
            if (obj instanceof InputStream) {
                is = (InputStream)obj;
            } else {
                TypeConverterRegistry registry = exchange.getContext().getTypeConverterRegistry();
                TypeConverter tc = registry.lookup(InputStream.class, obj.getClass());
                if (tc != null) {
                    is = (InputStream)tc.convertTo(InputStream.class, exchange, obj);
                }
            }
            if (is != null && (content = IOUtils.toString((InputStream)is)) != null) {
                value.setValue((Object)content);
            }
        } else {
            String content;
            Object obj = response.getEntity();
            if (obj == null) {
                return null;
            }
            InputStream is = null;
            if (obj instanceof InputStream) {
                is = (InputStream)obj;
            } else {
                TypeConverterRegistry registry = exchange.getContext().getTypeConverterRegistry();
                TypeConverter tc = registry.lookup(InputStream.class, obj.getClass());
                if (tc != null) {
                    is = (InputStream)tc.convertTo(InputStream.class, exchange, obj);
                }
            }
            if (is != null && (content = IOUtils.toString((InputStream)is)) != null) {
                String contentType = null;
                List list = (List)response.getMetadata().get((Object)"Content-Type");
                if (list != null && list.size() > 0) {
                    contentType = (String)list.get(0);
                }
                if (contentType == null) {
                    contentType = "text/xml";
                }
                XQPart part = message.createPart((Object)content, contentType);
                part.setContentId("Response");
                message.addPart(part);
            }
        }
        return message;
    }

    @Converter
    public static XQMessage toXQMessage(InputStream inputStream, Exchange exchange) throws Exception {
        XQServiceContext serviceContext = EsbUtils.getServiceContext(exchange);
        XQMessage message = XQMessageConverter.constructXQMessage(exchange, serviceContext, true);
        String contentType = null;
        if (XQMessageConverter.isARequest(exchange)) {
            contentType = (String)exchange.getIn().getHeader("Content-Type", String.class);
        }
        XQPart part = null;
        if ("application/octet-stream".equals(contentType)) {
            byte[] bContent = IOUtils.readBytesFromStream((InputStream)inputStream);
            part = message.createPart((Object)bContent, contentType);
        } else {
            String content = IOUtils.toString((InputStream)inputStream);
            if (content != null) {
                part = message.createPart((Object)content, contentType);
            }
        }
        if (part == null) {
            part = message.createPart((Object)"", contentType);
        }
        part.setContentId("PostData");
        if (message.doesPartExist("PostData")) {
            message.replacePart(part, part.getContentId());
        } else {
            message.addPart(part);
        }
        return message;
    }

    @Converter
    public static XQMessage toXQMessage(Boolean reuse, Exchange exchange) throws Exception {
        XQServiceContext serviceContext = EsbUtils.getServiceContext(exchange);
        XQMessage message = XQMessageConverter.constructXQMessage(exchange, serviceContext, reuse);
        Message inMessage = exchange.getIn();
        String contentType = (String)inMessage.getHeader("Content-Type", String.class);
        XQPart part = message.createPart(inMessage.getBody(), contentType);
        part.setContentId("PostData");
        message.addPart(part);
        return message;
    }

    @Converter
    public static Element toElement(String value) throws XQMessageException {
        try {
            return XQMessageConverter.getDocumentBuilder().parse(new InputSource(new StringReader(value))).getDocumentElement();
        }
        catch (Exception e) {
            throw new XQMessageException("Exception creating element", (Throwable)e);
        }
    }

    private static DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        SoftReference<DocumentBuilder> ref = threadLocalDocBuilder.get();
        DocumentBuilder answer = null;
        if (ref != null) {
            answer = ref.get();
        }
        if (answer != null) {
            answer.reset();
        } else {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setValidating(false);
            dbf.setIgnoringComments(false);
            dbf.setIgnoringElementContentWhitespace(true);
            dbf.setNamespaceAware(true);
            answer = dbf.newDocumentBuilder();
            answer.setEntityResolver((EntityResolver)new DOMUtils.NullResolver());
            threadLocalDocBuilder.set(new SoftReference<DocumentBuilder>(answer));
        }
        return answer;
    }

    @Converter
    public static String toString(Element value) throws Exception {
        return XMLUtils.toString((Node)value);
    }

    private static XQMessage convertFromCxfPayloadToXq(CxfPayload<SoapHeader> cxfPayload, Exchange exchange) throws Exception {
        XQServiceContext serviceContext = EsbUtils.getServiceContext(exchange);
        BindingOperationInfo boi = EsbUtils.getBindingOperationInfo(exchange);
        XQMessage message = XQMessageConverter.constructXQMessage(exchange, serviceContext, true);
        if (boi != null) {
            boolean isRequest = XQMessageConverter.isARequest(exchange);
            BindingMessageInfo msgInfo = isRequest ? boi.getInput() : boi.getOutput();
            ParameterValueMap params = XQMessageConverter.getParameterValueMap(serviceContext, isRequest);
            List<BindingRuleBean> bindingRules = XQMessageConverter.getBindingRules(isRequest, exchange);
            int i = 0;
            for (MessagePartInfo p : msgInfo.getMessageInfo().getMessageParts()) {
                boolean done = false;
                String partName = XQMessageConverter.getPartName(p);
                boolean isASoapPart = XQMessageConverter.isASoapMessagePart(msgInfo, partName);
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("CXF message part '" + partName + "' is a SOAP " + (isASoapPart ? "body part." : "header.")));
                }
                if (bindingRules != null && isASoapPart && XQMessageConverter.applyBindingRuleFromCamelBody(bindingRules, partName, (Element)cxfPayload.getBody().get(i), message, exchange)) {
                    ++i;
                    done = true;
                }
                if (!done && params != null && XQMessageConverter.setParameterValueFromCamelMessage(params, partName, p.getConcreteName(), isASoapPart, cxfPayload, i, isRequest)) {
                    if (isASoapPart) {
                        ++i;
                    }
                    done = true;
                }
                if (done || !XQMessageConverter.setXqMessagePartFromCamelMessage(message, partName, p.getConcreteName(), isASoapPart, cxfPayload, i, isRequest)) continue;
                if (isASoapPart) {
                    ++i;
                }
                done = true;
            }
            if (bindingRules != null && cxfPayload.getHeaders().size() > 0) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)((isRequest ? "Request" : "Response") + " message has " + cxfPayload.getHeaders().size() + " SOAP headers"));
                }
                XQMessageConverter.applyBindingRuleFromBindingHeader(bindingRules, cxfPayload.getHeaders(), message, exchange);
            }
        }
        return message;
    }

    private static Object applyBindingRuleToCamelBody(List<BindingRuleBean> bindingRules, XQMessage message, String partName, XQServiceContext serviceContext) {
        Object answer = null;
        for (BindingRuleBean bean : bindingRules) {
            BindingRule rule = bean.getBindingRule();
            if (rule.getTo().getValueType() != LocationValueType.CAMEL_BODY_PART || rule.getFrom().getValueType() != LocationValueType.EXPRESSION || !rule.getTo().getValue().equals(partName)) continue;
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Bind Camel Message with expression '" + rule.getTo().getValue() + "'"));
            }
            answer = EsbUtils.evaluate(rule.getFrom().getValue(), message, serviceContext);
            break;
        }
        return answer;
    }

    private static boolean setXqMessagePartFromCamelMessage(XQMessage message, String partName, QName concreteName, boolean isASoapPart, CxfPayload<SoapHeader> cxfPayload, int i, boolean isRequest) throws Exception {
        boolean answer = false;
        if (message.doesPartExist(partName)) {
            message.removePart(partName);
        }
        XQPart part = null;
        if (isASoapPart) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Set " + (isRequest ? "request" : "response") + " XQ message part '" + partName + "' with CXF payload part '" + partName + "'"));
            }
            part = message.createPart((Object)XMLUtils.toString((Node)((Node)cxfPayload.getBody().get(i))), "text/xml");
            answer = true;
        } else {
            Element soapHeader = XQMessageConverter.findSoapHeader(cxfPayload.getHeaders(), concreteName);
            if (soapHeader != null) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Set " + (isRequest ? "request" : "response") + " XQ message part '" + partName + "' with CXF SOAP header '" + concreteName + "'"));
                }
                part = message.createPart((Object)XMLUtils.toString((Node)soapHeader), "text/xml");
                answer = true;
            }
        }
        if (part != null) {
            part.setContentId(partName);
            message.addPart(part);
        }
        return answer;
    }

    private static boolean setParameterValueFromCamelMessage(ParameterValueMap params, String partName, QName concreteName, boolean isASoapPart, CxfPayload<SoapHeader> cxfPayload, int i, boolean isRequest) throws Exception {
        boolean answer = false;
        ParameterValue value = params.getParameterValue(partName);
        if (value != null) {
            if (isASoapPart) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Set " + (isRequest ? "IN" : "OUT") + " parameter '" + partName + "' with CXF payload part '" + partName + "'"));
                }
                value.setValue((Object)XMLUtils.toString((Node)((Node)cxfPayload.getBody().get(i))));
                answer = true;
            } else {
                Element soapHeader = XQMessageConverter.findSoapHeader(cxfPayload.getHeaders(), concreteName);
                if (soapHeader != null) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Set " + (isRequest ? "IN" : "OUT") + " parameter '" + partName + "' with CXF SOAP header '" + concreteName + "'"));
                    }
                    value.setValue((Object)XMLUtils.toString((Node)soapHeader));
                    answer = true;
                }
            }
        }
        return answer;
    }

    private static boolean applyBindingRuleFromBindingHeader(List<BindingRuleBean> bindingRules, List<SoapHeader> headers, XQMessage message, Exchange exchange) throws Exception {
        boolean answer = false;
        for (SoapHeader header : headers) {
            for (BindingRuleBean bean : bindingRules) {
                BindingRule rule = bean.getBindingRule();
                if (rule.getTo().getValueType() != LocationValueType.EXPRESSION || rule.getFrom().getValueType() != LocationValueType.CAMEL_BINDING_HEADER || !rule.getFrom().getValue().equals(header.getName().toString())) continue;
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Bind expression '" + rule.getTo().getValue() + "' with CXF SOAP header '" + header.getName() + "'"));
                }
                EsbUtils.setExpressionValue(rule.getTo().getValue(), XMLUtils.toString((Node)((Element)header.getObject())), message, exchange);
                answer = true;
            }
        }
        return answer;
    }

    private static boolean applyBindingRuleFromCamelBody(List<BindingRuleBean> bindingRules, String partName, Element element, XQMessage message, Exchange exchange) throws Exception {
        boolean answer = false;
        for (BindingRuleBean bean : bindingRules) {
            BindingRule rule = bean.getBindingRule();
            if (rule.getTo().getValueType() != LocationValueType.EXPRESSION || rule.getFrom().getValueType() != LocationValueType.CAMEL_BODY_PART || !rule.getFrom().getValue().equals(partName)) continue;
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Bind expression '" + rule.getTo().getValue() + "' with CXF payload part '" + partName + "'"));
            }
            EsbUtils.setExpressionValue(rule.getTo().getValue(), XMLUtils.toString((Node)element), message, exchange);
            answer = true;
            break;
        }
        return answer;
    }

    private static boolean isASoapMessagePart(BindingMessageInfo msgInfo, String partName) {
        for (MessagePartInfo p : msgInfo.getMessageParts()) {
            if (!partName.equals(XQMessageConverter.getPartName(p))) continue;
            return true;
        }
        return false;
    }

    private static XQMessage constructXQMessage(Exchange exchange, XQServiceContext serviceContext, boolean permitReuse) throws Exception {
        XQMessage message;
        if (permitReuse && serviceContext != null) {
            XQEnvelope envelope = serviceContext.getFirstIncoming();
            message = envelope.getMessage();
        } else {
            XQInitContext initContext = (XQInitContext)exchange.getProperty(XQInitContext.class.getName(), XQInitContext.class);
            ObjectHelper.notNull((Object)initContext, (String)XQInitContext.class.getName());
            message = initContext.getMessageFactory().createMessage();
        }
        return message;
    }

    private static List<BindingRuleBean> getBindingRules(boolean isRequest, Exchange exchange) {
        List<BindingRuleBean> answer = null;
        BindingRules rules = null;
        Object obj = exchange.getProperty(BindingStrategy.class.getName());
        if (obj instanceof BindingRules) {
            rules = (BindingRules)obj;
        }
        if (rules != null) {
            answer = isRequest ? rules.getInBindingRules() : rules.getOutBindingRules();
        }
        return answer;
    }

    private static String getPartName(MessagePartInfo p) {
        return p.getName().getLocalPart();
    }

    private static ParameterValueMap getParameterValueMap(XQServiceContext sc, boolean isRequest) {
        InvocationContext invocationContext;
        ParameterValueMap answer = null;
        if (sc != null && (invocationContext = (InvocationContext)sc.getInvocationContext()) != null) {
            answer = isRequest ? invocationContext.getInputParameterValues() : invocationContext.getOutputParameterValues();
        }
        return answer;
    }

    private static boolean isARequest(Exchange exchange) {
        return !exchange.hasOut();
    }
}

