/*
 * Decompiled with CFR 0.152.
 */
package com.progress.sonic.esb.camel.util;

import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQPart;
import java.io.Reader;
import java.io.StringReader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.util.ByteArrayDataSource;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.XPathUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class AttachmentUtils {
    protected static final String XOP_INC_NS = "http://www.w3.org/2004/08/xop/include";
    protected static final String XOP_INC_LOCAL_NAME = "Include";
    protected static final String HREF_ATTR_NAME = "href";
    private static final String HREF_SEARCH_EXPRESSION = "//xop:Include/@href";
    private static final XPathUtils XPATH;
    private static final String CID_PREFIX = "cid:";

    private AttachmentUtils() {
    }

    public static Collection<String> getHrefs(String string) throws Exception {
        Element doc = DOMUtils.readXml((Reader)new StringReader(string)).getDocumentElement();
        NodeList nodeList = XPATH.getValueList(HREF_SEARCH_EXPRESSION, (Node)doc);
        if (nodeList == null) {
            return Collections.emptyList();
        }
        ArrayList<String> answer = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (answer == null) {
                answer = new ArrayList<String>();
            }
            answer.add(nodeList.item(i).getNodeValue());
        }
        return answer;
    }

    public static void applyHRefAttachment(Map<String, DataHandler> answer, String href, XQMessage xqMessage) throws Exception {
        String reference = href;
        if (href.startsWith(CID_PREFIX)) {
            reference = href.substring(4);
        }
        XQPart attachmentPart = xqMessage.getPart(reference);
        answer.put(reference, attachmentPart.getDataHandler());
    }

    public static Map<String, DataHandler> replaceBase64(Document doc, Map<String, String> xpathNS, Collection<String> xpaths) throws Exception {
        XPathUtils xpathUtils = new XPathUtils(xpathNS);
        HashMap<String, DataHandler> retval = new HashMap<String, DataHandler>();
        for (String xpath : xpaths) {
            Node node = xpathUtils.getValueNode(xpath, (Node)doc);
            if (node == null) continue;
            String namespaceURI = node.getNamespaceURI();
            String qualifiedName = node.getLocalName();
            Element newNode = doc.createElementNS(namespaceURI, qualifiedName);
            Element xopInclude = doc.createElementNS(XOP_INC_NS, XOP_INC_LOCAL_NAME);
            String cid = AttachmentUtils.getUniqueCid();
            xopInclude.setAttribute(HREF_ATTR_NAME, CID_PREFIX + cid);
            String content = node.getTextContent();
            if (content != null) {
                retval.put(cid, new DataHandler((DataSource)new ByteArrayDataSource(Base64Utility.decode((String)content), "application/octet-stream")));
            }
            newNode.appendChild(xopInclude);
            node.getParentNode().replaceChild(newNode, node);
        }
        return retval;
    }

    private static String getUniqueCid() throws Exception {
        String s = UUID.randomUUID() + "@progress.com";
        return URLDecoder.decode(s, "UTF-8");
    }

    static {
        HashMap<String, String> ns = new HashMap<String, String>();
        ns.put("xop", XOP_INC_NS);
        XPATH = new XPathUtils(ns);
    }
}

