/*
 * Decompiled with CFR 0.152.
 */
package com.progress.sonic.esb.camel.util;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.camel.component.cxf.util.CxfUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class RestAttachmentUtils {
    private RestAttachmentUtils() {
    }

    public static Collection<AttachmentSpec> getAttachmentSpecifications(Element doc) throws Exception {
        NodeList attachmentList = doc.getElementsByTagNameNS("http://www.progress.com/sonic/esb/service/connect/attachmentspec", "attachment");
        ArrayList<AttachmentSpec> answer = null;
        int attachmentCount = attachmentList.getLength();
        if (attachmentCount > 0) {
            answer = new ArrayList<AttachmentSpec>();
        }
        for (int i = 0; i < attachmentCount; ++i) {
            AttachmentSpec as;
            Element attachmentElement = (Element)attachmentList.item(i);
            String name = attachmentElement.getAttribute("name");
            String contentType = attachmentElement.getAttribute("content-type");
            Element subAttachmentElement = (Element)attachmentElement.getElementsByTagName("*").item(0);
            if ("expression".equals(subAttachmentElement.getLocalName())) {
                Text elt = (Text)subAttachmentElement.getFirstChild();
                as = new AttachmentSpec(name, contentType, elt.getData(), SpecType.EXPRESSION);
                answer.add(as);
                continue;
            }
            if ("Include".equals(subAttachmentElement.getLocalName())) {
                String href = subAttachmentElement.getAttribute("href");
                as = new AttachmentSpec(name, contentType, href, SpecType.HREF);
                answer.add(as);
                continue;
            }
            if (!"inline".equals(subAttachmentElement.getLocalName())) continue;
            Node inlineNode = subAttachmentElement.getFirstChild();
            String partContents = null;
            if (inlineNode instanceof Text) {
                partContents = inlineNode.getNodeValue();
            } else if (inlineNode instanceof Element) {
                partContents = CxfUtils.elementToString((Element)((Element)inlineNode));
            }
            AttachmentSpec as2 = new AttachmentSpec(name, contentType, partContents, SpecType.INLINE);
            answer.add(as2);
        }
        return answer;
    }

    public static enum SpecType {
        HREF,
        EXPRESSION,
        INLINE;

    }

    public static class AttachmentSpec {
        private String itsContentType;
        private Object itsValue;
        private String itsName;
        private SpecType itsSpecType;

        AttachmentSpec(String name, String contentType, Object value, SpecType specType) {
            this.itsName = name;
            this.itsContentType = contentType;
            this.itsValue = value;
            this.itsSpecType = specType;
        }

        public String getName() {
            return this.itsName;
        }

        public String getContentType() {
            return this.itsContentType;
        }

        public Object getValue() {
            return this.itsValue;
        }

        public SpecType getSpecType() {
            return this.itsSpecType;
        }
    }
}

