/*
 * Decompiled with CFR 0.152.
 */
package com.progress.sonic.esb.camel;

import com.progress.sonic.esb.camel.AsyncResponseHandler;
import com.progress.sonic.esb.camel.DefaultEsbMessageExchange;
import com.progress.sonic.esb.camel.EsbMessageExchange;
import com.progress.sonic.esb.camel.EsbMessageExchangeFactory;
import com.progress.sonic.esb.camel.OnewayEsbMessageExchange;
import com.progress.sonic.esb.camel.SonicEsbEndpoint;
import com.progress.sonic.esb.camel.SyncEsbMessageExchange;
import org.apache.camel.Exchange;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultEsbMessageExchangeFactory
implements EsbMessageExchangeFactory {
    private static final Log LOG = LogFactory.getLog(DefaultEsbMessageExchangeFactory.class);

    @Override
    public EsbMessageExchange createEsbMessageExchange(Exchange exchange, SonicEsbEndpoint sonicEndpoint) {
        EsbMessageExchange esbMex = null;
        if (exchange.getPattern().isOutCapable()) {
            if (sonicEndpoint.getEsbConfig().isAsyncExchange()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)"Creating a Async ESB message exchange");
                }
                esbMex = new DefaultEsbMessageExchange((AsyncResponseHandler)exchange.getProperty(AsyncResponseHandler.class.getName(), AsyncResponseHandler.class), sonicEndpoint.getProcessAddressFactory());
            } else {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)"Creating a Sync  ESB message exchange");
                }
                esbMex = new SyncEsbMessageExchange(sonicEndpoint.getXqConfigManager());
            }
        } else {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"Creating a one-way ESB message exchange");
            }
            esbMex = new OnewayEsbMessageExchange();
        }
        return esbMex;
    }
}

