/*
 * Decompiled with CFR 0.152.
 */
package com.progress.sonic.esb.camel.util;

import com.progress.sonic.esb.camel.util.URITemplateHolder;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.model.URITemplate;

public final class URLTemplateUtils {
    private URLTemplateUtils() {
    }

    public static String extractQueryString(String uri) {
        int queryIdx = uri.lastIndexOf("?");
        if (queryIdx != -1 && queryIdx < uri.length()) {
            return uri.substring(queryIdx + 1);
        }
        return null;
    }

    public static String extractPathString(String uri) {
        int queryIdx = uri.lastIndexOf("?");
        if (queryIdx != -1 && queryIdx < uri.length()) {
            return uri.substring(0, queryIdx);
        }
        return uri;
    }

    public static Map<String, String> extractQueryMap(String uri) {
        LinkedHashMap<String, String> queryMap = new LinkedHashMap<String, String>();
        int queryIdx = uri.lastIndexOf("?");
        if (queryIdx != -1 && queryIdx < uri.length()) {
            String queryPart = uri.substring(queryIdx + 1);
            String[] nEqVs = queryPart.split("&");
            for (int i = 0; i < nEqVs.length; ++i) {
                String nEqV = nEqVs[i];
                int eqIdx = nEqV.indexOf("=");
                if (eqIdx != -1 && eqIdx < nEqV.length()) {
                    queryMap.put(nEqV.substring(0, eqIdx), nEqV.substring(eqIdx + 1));
                    continue;
                }
                queryMap.put(nEqV, "");
            }
        }
        return queryMap;
    }

    public static String formalizeURLTemplate(String template) {
        String result = template;
        Character nextChar = null;
        int qMarkIdx = result.indexOf("?");
        if (qMarkIdx == -1) {
            return result;
        }
        if (qMarkIdx < result.length() - 1) {
            nextChar = new Character(result.charAt(qMarkIdx + 1));
        }
        if (nextChar == null || nextChar.charValue() != ']' && nextChar.charValue() != '}') {
            result = result.replaceFirst("[\\?]", "[\\\\x3f]");
            result = result.replaceAll("[\\x26]", "[\\\\x26]");
            result = result.replaceAll("[}]", ":[^;\\\\x3f\\\\x26\\\\/]+?}");
            return result;
        }
        return result;
    }

    public static int bestTemplateMatch(List<URITemplateHolder> templates, MultivaluedMap<String, String> values, String pathAndQuery) {
        int bestMatchSlot = -1;
        MetadataMap localValues = new MetadataMap();
        for (int idx = 0; idx < templates.size(); ++idx) {
            URITemplateHolder templateHolder = templates.get(idx);
            URITemplate template = templateHolder.getTemplate();
            boolean templateIncludesQueryMatching = templateHolder.getUri().indexOf("?") != -1;
            String candidate = templateIncludesQueryMatching ? pathAndQuery : URLTemplateUtils.extractPathString(pathAndQuery);
            String query = URLTemplateUtils.extractQueryString(pathAndQuery);
            localValues.clear();
            if (!template.match(candidate, (MultivaluedMap)localValues)) continue;
            String trailingMatch = (String)localValues.getFirst((Object)"FINAL_MATCH_GROUP");
            if (!templateIncludesQueryMatching && query != null && query.length() > 0) {
                trailingMatch = trailingMatch == null ? "?" + query : trailingMatch + "?" + query;
            }
            if (trailingMatch != null && !"".equals(trailingMatch) && !"/".equals(trailingMatch)) {
                if (values.size() >= localValues.size()) continue;
                values.clear();
                values.putAll((Map)localValues);
                bestMatchSlot = idx;
                continue;
            }
            values.clear();
            values.putAll((Map)localValues);
            bestMatchSlot = idx;
            break;
        }
        return bestMatchSlot;
    }
}

