/*
 * Decompiled with CFR 0.152.
 */
package com.progress.sonic.esb.camel;

import com.progress.sonic.esb.camel.AbstractRuleBasedBindingStrategy;
import com.progress.sonic.esb.camel.AttachmentReferencesDetection;
import com.progress.sonic.esb.camel.converter.XQMessageConverter;
import com.progress.sonic.esb.camel.util.AttachmentUtils;
import com.progress.sonic.esb.camel.util.EsbUtils;
import com.sonicsw.esb.process.mapping.ParameterValue;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQPart;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.activation.DataHandler;
import org.apache.camel.Exchange;
import org.apache.cxf.binding.soap.SoapHeader;
import org.apache.cxf.headers.Header;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.staxutils.StaxUtils;
import org.w3c.dom.Document;

public class SoapBindingStrategy
extends AbstractRuleBasedBindingStrategy {
    private Map<String, String> base64AsAttachmentNamespaces;
    private Collection<String> base64AsAttachmentXPaths;

    @Override
    public Map<String, Object> bindRequestHeadersFromXQMessage(XQMessage message, Exchange exchange) throws Exception {
        Map<String, Object> answer = super.bindRequestHeadersFromXQMessage(message, exchange);
        ArrayList<SoapHeader> soapHeaders = new ArrayList<SoapHeader>();
        XQMessageConverter.applyBindingRuleToSoapHeader(this.getInBindingRules(), soapHeaders, message, EsbUtils.getServiceContext(exchange), exchange.getContext().getTypeConverterRegistry());
        if (!soapHeaders.isEmpty()) {
            answer.put(Header.HEADER_LIST, soapHeaders);
        }
        return answer;
    }

    @Override
    public void bindExchangeFromEsbResponse(Exchange exchange, XQMessage message) throws Exception {
        super.bindExchangeFromEsbResponse(exchange, message);
        ArrayList<SoapHeader> soapHeaders = (ArrayList<SoapHeader>)exchange.getOut().getHeader(Header.HEADER_LIST);
        boolean newList = false;
        if (soapHeaders == null) {
            soapHeaders = new ArrayList<SoapHeader>();
            newList = true;
        }
        XQMessageConverter.applyBindingRuleToSoapHeader(this.getOutBindingRules(), soapHeaders, message, EsbUtils.getServiceContext(exchange), exchange.getContext().getTypeConverterRegistry());
        if (newList && !soapHeaders.isEmpty()) {
            exchange.getOut().setHeader(Header.HEADER_LIST, soapHeaders);
        }
    }

    @Override
    protected Map<String, DataHandler> scanAttachments(AttachmentReferencesDetection scanAction, Exchange exchange, XQMessage xqMessage, boolean isRequest) throws Exception {
        HashMap<String, DataHandler> answer;
        block4: {
            block3: {
                answer = new HashMap<String, DataHandler>();
                if (!isRequest) break block3;
                Iterator pvs = EsbUtils.getInputParamValueMap(exchange).getParameterValues();
                while (pvs.hasNext()) {
                    this.scanAttachmentsFromParameter(scanAction, (ParameterValue)pvs.next(), xqMessage, answer);
                }
                break block4;
            }
            BindingOperationInfo boi = EsbUtils.getBindingOperationInfo(exchange);
            BindingMessageInfo msgInfo = null;
            if (boi != null) {
                msgInfo = boi.getOutput();
            }
            if (msgInfo == null) break block4;
            for (MessagePartInfo p : msgInfo.getMessageInfo().getMessageParts()) {
                String partName = p.getName().getLocalPart();
                if (!xqMessage.doesPartExist(partName)) continue;
                this.scanAttachmentsFromXQPart(scanAction, xqMessage.getPart(partName), xqMessage, answer);
            }
        }
        return answer;
    }

    private void scanAttachmentsFromXQPart(AttachmentReferencesDetection scanAction, XQPart part, XQMessage xqMessage, Map<String, DataHandler> answer) throws Exception {
        Object result;
        if ("text/xml".equalsIgnoreCase(part.getContentType()) && (result = part.getContent()) instanceof String) {
            if (scanAction == AttachmentReferencesDetection.SCAN_MESSAGE_PARTS) {
                try {
                    this.collectHrefAttachments(answer, xqMessage, (String)result);
                }
                catch (Exception exception) {}
            } else if (scanAction == AttachmentReferencesDetection.BASE64_AS_ATTACHMENTS) {
                this.base64ToAttachmentsFromXQPart(answer, part, (String)result);
            }
        }
    }

    private void scanAttachmentsFromParameter(AttachmentReferencesDetection scanAction, ParameterValue parameter, XQMessage xqMessage, Map<String, DataHandler> answer) throws Exception {
        if (!(parameter.getValue() instanceof String)) {
            return;
        }
        String value = (String)parameter.getValue();
        if (scanAction == AttachmentReferencesDetection.SCAN_MESSAGE_PARTS) {
            try {
                this.collectHrefAttachments(answer, xqMessage, value);
            }
            catch (Exception exception) {}
        } else if (scanAction == AttachmentReferencesDetection.BASE64_AS_ATTACHMENTS) {
            this.base64ToAttachmentsFromParameter(answer, parameter, value);
        }
    }

    private void base64ToAttachmentsFromParameter(Map<String, DataHandler> answer, ParameterValue parameter, String value) throws Exception {
        Document doc = StaxUtils.read((Reader)new StringReader(value));
        Map<String, DataHandler> attachments = AttachmentUtils.replaceBase64(doc, this.base64AsAttachmentNamespaces, this.base64AsAttachmentXPaths);
        parameter.setValue((Object)StaxUtils.toString((Document)doc));
        answer.putAll(attachments);
    }

    private void base64ToAttachmentsFromXQPart(Map<String, DataHandler> answer, XQPart part, String value) throws Exception {
        Document doc = StaxUtils.read((Reader)new StringReader(value));
        Map<String, DataHandler> attachments = AttachmentUtils.replaceBase64(doc, this.base64AsAttachmentNamespaces, this.base64AsAttachmentXPaths);
        part.setContent((Object)StaxUtils.toString((Document)doc), "text/xml");
        answer.putAll(attachments);
    }

    @Override
    protected String coerceContentType(String contentType) {
        return "application/octet-stream";
    }

    private void collectHrefAttachments(Map<String, DataHandler> answerParam, XQMessage xqMessage, String doc) throws Exception {
        Map<String, DataHandler> answer = answerParam;
        Collection<String> hrefs = AttachmentUtils.getHrefs(doc);
        if (!hrefs.isEmpty()) {
            for (String href : hrefs) {
                if (hrefs.isEmpty()) {
                    answer = new HashMap<String, DataHandler>();
                }
                AttachmentUtils.applyHRefAttachment(answer, href, xqMessage);
            }
        }
    }

    public Map<String, String> getBase64AsAttachmentNamespaces() {
        return this.base64AsAttachmentNamespaces;
    }

    public void setBase64AsAttachmentNamespaces(Map<String, String> base64AsAttachmentNamespaces) {
        this.base64AsAttachmentNamespaces = base64AsAttachmentNamespaces;
    }

    public Collection<String> getBase64AsAttachmentXPaths() {
        return this.base64AsAttachmentXPaths;
    }

    public void setBase64AsAttachmentXPaths(Collection<String> base64AsAttachmentXPaths) {
        this.base64AsAttachmentXPaths = base64AsAttachmentXPaths;
    }
}

