/*
 * Decompiled with CFR 0.152.
 */
package com.progress.sonic.esb.camel;

import com.progress.sonic.esb.camel.IntrinsicFilters;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.camel.support.DefaultHeaderFilterStrategy;

public class SonicHeaderFilterStrategy
extends DefaultHeaderFilterStrategy
implements IntrinsicFilters {
    protected DefaultHeaderFilterStrategy inheritFiltersFrom;
    private Set<String> inIntrinsicFilters;
    private Set<String> outIntrinsicFilters;
    private boolean isCaseInsensitive = true;

    public SonicHeaderFilterStrategy() {
        this.initialize();
    }

    public DefaultHeaderFilterStrategy getInheritFiltersFrom() {
        return this.inheritFiltersFrom;
    }

    private void initialize() {
        this.getOutFilter().clear();
        this.getInFilter().clear();
        this.setOutFilterPattern(null);
        this.setInFilterPattern(null);
        if (this.isCaseInsensitive) {
            this.setLowerCase(true);
        }
        this.inIntrinsicFilters = new HashSet<String>();
        this.outIntrinsicFilters = new HashSet<String>();
        this.addOutIntrinsicFilter("breadcrumbId");
        this.addOutIntrinsicFilter("CamelHttpResponseCode");
        this.addOutIntrinsicFilter("CamelCxfRsQueryMap");
        this.addOutIntrinsicFilter("CamelCxfRsUsingHttpAPI");
        this.addOutIntrinsicFilter("CamelCxfMessage");
        this.addOutIntrinsicFilter("operationNamespace");
        this.addOutIntrinsicFilter("Accept");
        this.setOutFilter(this.outIntrinsicFilters);
    }

    public void setInheritFiltersFrom(DefaultHeaderFilterStrategy inheritFiltersFrom) {
        if (inheritFiltersFrom != null) {
            if (inheritFiltersFrom.getInFilterPattern() != null && this.getInFilterPattern() == null) {
                this.setInFilterPattern(inheritFiltersFrom.getInFilterPattern());
            }
            if (inheritFiltersFrom.getOutFilterPattern() != null && this.getOutFilterPattern() == null) {
                this.setOutFilterPattern(inheritFiltersFrom.getOutFilterPattern());
            }
            this.setInFilter(inheritFiltersFrom.getInFilter());
            this.setOutFilter(inheritFiltersFrom.getOutFilter());
        }
        this.inheritFiltersFrom = inheritFiltersFrom;
    }

    public void setInFilter(Set<String> value) {
        if (value != null) {
            if (!this.isCaseInsensitive) {
                this.getInFilter().addAll(value);
            } else {
                for (String filter : value) {
                    String lowercaseFilter = filter.toLowerCase(Locale.ENGLISH);
                    this.getInFilter().add(lowercaseFilter);
                    if (filter.equals(lowercaseFilter)) continue;
                    this.getInFilter().add(filter);
                }
            }
        }
    }

    public void setOutFilter(Set<String> value) {
        if (value != null) {
            if (!this.isCaseInsensitive) {
                this.getOutFilter().addAll(value);
            } else {
                for (String filter : value) {
                    String lowercaseFilter = filter.toLowerCase(Locale.ENGLISH);
                    this.getOutFilter().add(lowercaseFilter);
                    if (filter.equals(lowercaseFilter)) continue;
                    this.getOutFilter().add(filter);
                }
            }
        }
    }

    @Override
    public Set<String> getInIntrinsicFilters() {
        return this.inIntrinsicFilters;
    }

    @Override
    public Set<String> getOutIntrinsicFilters() {
        return this.outIntrinsicFilters;
    }

    public void setCaseInsensitive(boolean isCaseInsensitive) {
        this.isCaseInsensitive = isCaseInsensitive;
    }

    public boolean isCaseInsensitive() {
        return this.isCaseInsensitive;
    }

    private void addOutIntrinsicFilter(String filter) {
        if (this.outIntrinsicFilters == null) {
            this.outIntrinsicFilters = new HashSet<String>();
        }
        this.outIntrinsicFilters.add(filter);
        String lowercaseFilter = filter.toLowerCase(Locale.ENGLISH);
        this.outIntrinsicFilters.add(lowercaseFilter);
        if (!filter.equals(lowercaseFilter)) {
            this.outIntrinsicFilters.add(filter);
        }
    }
}

