/*
 * Decompiled with CFR 0.152.
 */
package com.progress.sonic.esb.camel;

import com.progress.sonic.esb.camel.BindingStrategy;
import com.progress.sonic.esb.camel.DirectSonicEsbEndpoint;
import com.progress.sonic.esb.camel.util.AttachmentUtils;
import com.sonicsw.xq.XQMessage;
import java.io.ByteArrayInputStream;
import java.util.Map;
import javax.activation.DataHandler;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.direct.DirectEndpoint;
import org.apache.camel.component.direct.DirectProducer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DirectSonicEsbProducer
extends DirectProducer {
    private static final transient Log LOG = LogFactory.getLog(DirectSonicEsbProducer.class);

    public DirectSonicEsbProducer(DirectSonicEsbEndpoint endpoint) {
        super((DirectEndpoint)endpoint);
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            this.process(exchange);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        callback.done(true);
        return true;
    }

    public void process(Exchange exchange) throws Exception {
        XQMessage out;
        BindingStrategy binding;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Process exchange: " + exchange));
        }
        if ((binding = (BindingStrategy)exchange.getProperty(BindingStrategy.class.getName(), BindingStrategy.class)) == null) {
            binding = ((DirectSonicEsbEndpoint)this.getEndpoint()).getBindingStrategy();
        }
        if (binding == null) {
            super.process(exchange);
            return;
        }
        Message inMessage = exchange.getIn();
        Object obj = inMessage.getBody();
        if (!(obj instanceof XQMessage)) {
            super.process(exchange);
            return;
        }
        XQMessage xqMessage = (XQMessage)obj;
        Map<String, Object> headers = binding.bindRequestHeadersFromXQMessage(xqMessage, exchange);
        if (headers != null && headers.size() > 0) {
            inMessage.getHeaders().putAll(headers);
        }
        Object body = binding.bindRequestBodyFromXQMessage(xqMessage, exchange);
        this.handleBodyType(body, inMessage);
        Map<String, DataHandler> attachments = binding.bindRequestAttachmentsFromXQMessage(xqMessage, exchange);
        if (attachments != null) {
            for (Map.Entry<String, DataHandler> entry : attachments.entrySet()) {
                AttachmentUtils.addAttachment(inMessage.getExchange(), entry.getKey(), entry.getValue());
            }
        }
        if (((DirectSonicEsbEndpoint)this.getEndpoint()).getConsumer() == null) {
            throw new Exception("The Direct Endpoint '" + this.getEndpoint().getEndpointUri() + "' has no consumers.  Please make sure the esbcamel invocation target matches the 'from' endpoint of the intended route in spring.xml");
        }
        super.process(exchange);
        if (((DirectSonicEsbEndpoint)this.getEndpoint()).isResponseConverted() && exchange.getPattern().isOutCapable() && (out = binding.bindResponseBodyFromCamelExchange(exchange)) != null) {
            exchange.getOut().setBody((Object)out);
        }
    }

    private void handleBodyType(Object body, Message inMessage) {
        if (body != null) {
            if (this.shouldBodyBeAByteArrayInputStream(inMessage, body)) {
                ByteArrayInputStream bis = new ByteArrayInputStream((byte[])body);
                inMessage.setBody((Object)bis);
            } else {
                inMessage.setBody(body);
            }
        }
    }

    private boolean shouldBodyBeAByteArrayInputStream(Message message, Object body) {
        return body instanceof byte[] && message.getHeader("Content-Type").toString().contains("application/octet-stream");
    }
}

