/*
 * Decompiled with CFR 0.152.
 */
package com.progress.sonic.esb.camel;

import com.progress.sonic.esb.camel.util.URLTemplateUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.model.URITemplate;

public class TemplateProcessor
implements Processor {
    List<URITemplate> utemplates;
    List<String> stemplates;

    public void process(Exchange ex) throws Exception {
        String path = (String)ex.getIn().getHeader("CamelHttpPath");
        if (path != null) {
            MetadataMap values = new MetadataMap();
            for (URITemplate t : this.utemplates) {
                if (!t.match(path, (MultivaluedMap)values)) continue;
                ex.setProperty("URITemplate", (Object)t.getValue());
                ex.setProperty("URI_TEMPLATE_PARMS", (Object)values);
                break;
            }
        }
    }

    public void setTemplates(List<String> templates) {
        this.stemplates = templates;
        this.utemplates = new ArrayList<URITemplate>();
        Iterator<String> it = this.stemplates.iterator();
        while (it.hasNext()) {
            this.utemplates.add(new URITemplate(URLTemplateUtils.formalizeURLTemplate(it.next())));
        }
    }

    public List<String> getTemplates() {
        return this.stemplates;
    }
}

