/*
 * Decompiled with CFR 0.152.
 */
package com.progress.sonic.esb.camel;

import com.progress.sonic.esb.camel.BindingStrategy;
import com.progress.sonic.esb.camel.DefaultDirectSonicEsbBindingStrategy;
import com.progress.sonic.esb.camel.DirectSonicEsbProducer;
import com.progress.sonic.esb.camel.NonStickyBindingStrategy;
import com.progress.sonic.esb.camel.XQInitContextAware;
import com.sonicsw.xq.XQInitContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Producer;
import org.apache.camel.Service;
import org.apache.camel.component.direct.DirectComponent;
import org.apache.camel.component.direct.DirectConsumer;
import org.apache.camel.component.direct.DirectEndpoint;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.camel.support.DefaultHeaderFilterStrategy;
import org.apache.camel.util.StringHelper;

public class DirectSonicEsbEndpoint
extends DirectEndpoint
implements XQInitContextAware,
Service {
    private HeaderFilterStrategy headerFilterStrategy;
    private BindingStrategy bindingStrategy;
    private XQInitContext xqInitContext;
    private String uriTemplateParm;
    private boolean responseConverted = true;
    private final String key;

    public DirectSonicEsbEndpoint(String uri, DirectComponent component) {
        super(uri, component);
        this.key = StringHelper.before((String)uri, (String)"?", (String)uri);
    }

    public Exchange createExchange() {
        return this.createExchange(this.getExchangePattern());
    }

    public Exchange createExchange(ExchangePattern pattern) {
        Exchange exchange = super.createExchange(pattern);
        if (this.bindingStrategy != null && !this.bindingStrategy.getClass().isAnnotationPresent(NonStickyBindingStrategy.class)) {
            exchange.setProperty(BindingStrategy.class.getName(), (Object)this.bindingStrategy);
        }
        if (this.uriTemplateParm != null) {
            exchange.setProperty("URITemplate", (Object)this.uriTemplateParm);
        }
        if (this.xqInitContext != null) {
            exchange.setProperty(XQInitContext.class.getName(), (Object)this.xqInitContext);
        }
        return exchange;
    }

    public Producer createProducer() throws Exception {
        return new DirectSonicEsbProducer(this, this.key);
    }

    public void setUriTemplate(String template) {
        this.uriTemplateParm = template.replaceAll("%3f", "?");
    }

    public String getUriTemplate() {
        return this.uriTemplateParm;
    }

    public void setBindingStrategy(BindingStrategy bindingStrategy) {
        this.bindingStrategy = bindingStrategy;
    }

    public BindingStrategy getBindingStrategy() {
        return this.bindingStrategy;
    }

    @Override
    public void setXQInitContext(XQInitContext context) {
        this.xqInitContext = context;
    }

    public XQInitContext getXQInitContext() {
        return this.xqInitContext;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy strategy) {
        this.headerFilterStrategy = strategy;
        if (this.bindingStrategy instanceof HeaderFilterStrategyAware) {
            ((HeaderFilterStrategyAware)this.bindingStrategy).setHeaderFilterStrategy(this.headerFilterStrategy);
        }
    }

    public void setResponseConverted(boolean responseConverted) {
        this.responseConverted = responseConverted;
    }

    public boolean isResponseConverted() {
        return this.responseConverted;
    }

    public void start() {
        if (this.headerFilterStrategy == null) {
            this.headerFilterStrategy = new DefaultHeaderFilterStrategy();
        }
        if (this.bindingStrategy == null) {
            this.bindingStrategy = new DefaultDirectSonicEsbBindingStrategy();
        }
        if (this.bindingStrategy instanceof HeaderFilterStrategyAware) {
            ((HeaderFilterStrategyAware)this.bindingStrategy).setHeaderFilterStrategy(this.getHeaderFilterStrategy());
        }
    }

    public void stop() {
    }

    public DirectConsumer getConsumer() throws InterruptedException {
        return super.getConsumer();
    }
}

