/*
 * Decompiled with CFR 0.152.
 */
package com.progress.sonic.esb.camel;

import com.progress.sonic.esb.camel.AsyncResponseHandler;
import com.progress.sonic.esb.camel.BindingStrategy;
import com.progress.sonic.esb.camel.DefaultProcessAddressFactory;
import com.progress.sonic.esb.camel.ProcessAddressFactory;
import com.progress.sonic.esb.camel.SonicEsbComponent;
import com.progress.sonic.esb.camel.SonicEsbConfig;
import com.progress.sonic.esb.camel.SonicEsbProducer;
import com.progress.sonic.esb.camel.SonicHeaderFilterStrategy;
import com.progress.sonic.esb.camel.StatsCollector;
import com.progress.sonic.esb.camel.StatsCollectorAware;
import com.progress.sonic.esb.camel.XQInitContextAware;
import com.sonicsw.xq.XQInitContext;
import com.sonicsw.xqimpl.config.IXQConfigManager;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.Service;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SonicEsbEndpoint
extends DefaultEndpoint
implements HeaderFilterStrategyAware,
XQInitContextAware,
StatsCollectorAware,
Service {
    private static final Log LOG = LogFactory.getLog(SonicEsbEndpoint.class);
    private HeaderFilterStrategy headerFilterStrategy;
    private XQInitContext xqInitContext;
    private BindingStrategy binding;
    private AsyncResponseHandler asyncResponseHandler;
    private SonicEsbConfig esbConfig;
    private ProcessAddressFactory processAddressFactory = new DefaultProcessAddressFactory();
    private IXQConfigManager xqConfigManager;
    private StatsCollector statsCollector;

    public SonicEsbEndpoint(SonicEsbComponent component, String remaining) {
        super(remaining, (Component)component);
        this.asyncResponseHandler = component.getAsyncResponseHandler();
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Producer createProducer() throws Exception {
        return new SonicEsbProducer(this);
    }

    public boolean isSingleton() {
        return true;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy strategy) {
        this.headerFilterStrategy = strategy;
        if (this.binding instanceof HeaderFilterStrategyAware) {
            ((HeaderFilterStrategyAware)this.binding).setHeaderFilterStrategy(this.headerFilterStrategy);
        }
    }

    @Override
    public void setXQInitContext(XQInitContext context) {
        this.xqInitContext = context;
        if (!this.asyncResponseHandler.hasBeenInitialized()) {
            try {
                this.asyncResponseHandler.setXqConfigManager(this.getXqConfigManager());
                this.asyncResponseHandler.init(context);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public XQInitContext getXQInitContext() {
        return this.xqInitContext;
    }

    public void setBindingStrategy(BindingStrategy bindingStrategy) {
        this.binding = bindingStrategy;
    }

    public BindingStrategy getBindingStrategy() {
        return this.binding;
    }

    AsyncResponseHandler getAsyncResponseHandler() {
        return this.asyncResponseHandler;
    }

    public void start() {
        if (this.headerFilterStrategy == null) {
            this.headerFilterStrategy = new SonicHeaderFilterStrategy();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Create default header filter strategy " + this.headerFilterStrategy));
            }
        }
        if (this.binding instanceof HeaderFilterStrategyAware) {
            ((HeaderFilterStrategyAware)this.binding).setHeaderFilterStrategy(this.getHeaderFilterStrategy());
        }
        if (this.esbConfig == null) {
            this.esbConfig = new SonicEsbConfig();
        }
    }

    public void stop() {
    }

    public void setEsbConfig(SonicEsbConfig esbConfig) {
        this.esbConfig = esbConfig;
    }

    public SonicEsbConfig getEsbConfig() {
        return this.esbConfig;
    }

    public void setProcessAddressFactory(ProcessAddressFactory processAddressFactory) {
        this.processAddressFactory = processAddressFactory;
    }

    public ProcessAddressFactory getProcessAddressFactory() {
        return this.processAddressFactory;
    }

    public void setXqConfigManager(IXQConfigManager xqConfigManager) {
        this.xqConfigManager = xqConfigManager;
        this.asyncResponseHandler.setXqConfigManager(xqConfigManager);
    }

    public IXQConfigManager getXqConfigManager() {
        return this.xqConfigManager;
    }

    @Override
    public void setStatsCollector(StatsCollector collector) {
        this.statsCollector = collector;
    }

    public StatsCollector getStatsCollector() {
        return this.statsCollector;
    }
}

