/*
 * Decompiled with CFR 0.152.
 */
package com.progress.sonic.esb.camel;

import com.progress.sonic.esb.camel.EsbMessageExchange;
import com.progress.sonic.esb.camel.SonicEsbEndpoint;
import com.progress.sonic.esb.camel.SonicEsbURI;
import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQEndpoint;
import com.sonicsw.xq.XQEndpointException;
import com.sonicsw.xq.XQInitContext;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQMessageException;
import com.sonicsw.xq.XQServiceContext;
import com.sonicsw.xq.XQServiceException;
import com.sonicsw.xqimpl.config.IXQConfigManager;
import com.sonicsw.xqimpl.config.XQConfigManager;
import com.sonicsw.xqimpl.config.XQConfigurationException;
import com.sonicsw.xqimpl.config.XQProcessConfig;
import com.sonicsw.xqimpl.config.XQServiceConfig;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.camel.Exchange;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SyncEsbMessageExchange
implements EsbMessageExchange {
    private static final Log LOG = LogFactory.getLog(SyncEsbMessageExchange.class);
    private IXQConfigManager configManager;
    private InitialContext context;

    SyncEsbMessageExchange(IXQConfigManager xqConfigManager) {
        this.configManager = xqConfigManager;
        if (Boolean.getBoolean("sonic.connect.jndi.lookupEnabled")) {
            try {
                this.context = new InitialContext();
            }
            catch (NamingException e) {
                LOG.error((Object)e);
            }
        } else if (this.configManager == null) {
            this.configManager = XQConfigManager.getInstance(null);
        }
    }

    @Override
    public XQMessage[] send(Exchange exchange, XQMessage inputMsg, SonicEsbEndpoint esbEndpoint) throws Exception {
        SonicEsbURI sonicURI = (SonicEsbURI)exchange.getProperty("sonicesb-uri-object");
        XQAddress destinationAddress = sonicURI.getXQAddress();
        XQInitContext xqInitContext = esbEndpoint.getXQInitContext();
        XQServiceContext xqServiceContext = (XQServiceContext)exchange.getProperty(XQServiceContext.class.getName(), XQServiceContext.class);
        if (xqServiceContext != null) {
            xqInitContext = xqServiceContext;
        }
        XQEndpoint xqEndpoint = this.getEndpoint(destinationAddress, xqInitContext);
        XQMessage[] messages = new XQMessage[]{xqEndpoint.call(inputMsg, esbEndpoint.getEsbConfig().getTimeoutInterval())};
        return messages;
    }

    private XQEndpoint getEndpoint(XQAddress destAddr, XQInitContext xqInitCtx) throws XQConfigurationException, XQEndpointException, XQMessageException, XQServiceException, NamingException {
        String entryEPName = null;
        if (destAddr.getType() == 0) {
            entryEPName = destAddr.getName();
        } else if (destAddr.getType() == 1 && xqInitCtx != null) {
            XQServiceConfig serviceConfig = this.lookupServiceConfig(destAddr.getName());
            entryEPName = serviceConfig.getEntryEndpoint();
        } else if (destAddr.getType() == 2 && xqInitCtx != null) {
            XQProcessConfig processConfig = this.lookupProcessConfig(destAddr.getName());
            entryEPName = processConfig.getEntryEndpoint();
        }
        if (entryEPName == null) {
            throw new XQServiceException("Cannot find entry endpoint for address `" + destAddr + "`. Please make sure entry endpoint is defined.");
        }
        XQEndpoint endpoint = xqInitCtx.getEndpointManager().getEndpoint(entryEPName);
        if (endpoint == null) {
            throw new XQServiceException("Cannot find endpoint corresponding to address `" + destAddr + "`");
        }
        return endpoint;
    }

    private XQServiceConfig lookupServiceConfig(String name) throws XQConfigurationException, NamingException {
        if (Boolean.getBoolean("sonic.connect.jndi.lookupEnabled")) {
            return (XQServiceConfig)this.context.lookup("service/" + name);
        }
        return this.configManager.lookupServiceConfig(name);
    }

    private XQProcessConfig lookupProcessConfig(String name) throws XQConfigurationException, NamingException {
        if (Boolean.getBoolean("sonic.connect.jndi.lookupEnabled")) {
            return (XQProcessConfig)this.context.lookup("process/" + name);
        }
        return this.configManager.lookupProcessConfig(name);
    }
}

