/*
 * Decompiled with CFR 0.152.
 */
package com.aurea.sonic.esb.connect.processor;

import com.aurea.sonic.esb.annotation.util.ProcessorContext;
import com.aurea.sonic.esb.connect.processor.model.ConnectModel;
import java.net.URI;
import java.net.URISyntaxException;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;

public class ConnectServiceValidator {
    private final ProcessorContext context;

    public ConnectServiceValidator(ProcessorContext context) {
        this.context = context;
    }

    public boolean validateService(ConnectModel service) {
        return this.validateBaseUrl(service);
    }

    private boolean validateBaseUrl(ConnectModel service) {
        if (service.getBaseUrl() == null || "".equals(service.getBaseUrl())) {
            this.addError(service.getType(), service.getClassName() + ": baseUrl is required (e.g: http://0.0.0.0:8080/)", new Object[0]);
            return false;
        }
        try {
            URI uri = new URI(service.getBaseUrl());
            if (uri.getScheme() == null || !uri.getScheme().toLowerCase().startsWith("http")) {
                this.addError(service.getType(), service.getClassName() + ": baseUrl should have 'http(s)' scheme (e.g: http://0.0.0.0:8080/)", new Object[0]);
                return false;
            }
            if (uri.getPath() == null || uri.getPath().isEmpty()) {
                this.addError(service.getType(), service.getClassName() + ": baseUrl should have '/' path (e.g: http://0.0.0.0:8080/)", new Object[0]);
                return false;
            }
        }
        catch (URISyntaxException ex) {
            this.addError(service.getType(), service.getClassName() + ": invalid baseUrl (" + ex.getMessage() + ")", new Object[0]);
            return false;
        }
        return true;
    }

    private void addError(Element element, String message, Object ... args) {
        String formattedMessage = String.format(message, args);
        this.context.getMessager().printMessage(Diagnostic.Kind.ERROR, formattedMessage, element);
    }
}

