/*
 * Decompiled with CFR 0.152.
 */
package com.aurea.sonic.esb.connect.processor.model;

import com.aurea.sonic.esb.annotation.util.ElementUtil;
import com.aurea.sonic.esb.annotation.util.ProcessorContext;
import com.aurea.sonic.esb.connect.processor.model.ParameterKind;
import com.aurea.sonic.esb.connect.processor.model.ParameterModel;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;

public class ResourceModel {
    public static final String ROOT = "root";
    private final Element type;
    private String name;
    private String path;
    private String qualifiedPath;
    private final Set<ParameterModel> parameters = new LinkedHashSet<ParameterModel>();

    public ResourceModel(ProcessorContext context, Element element, String parentPath) {
        this.type = element;
        Path pathAnnotation = element.getAnnotation(Path.class);
        if (parentPath == null) {
            this.name = ROOT;
            this.path = this.sanitizeAnnotationPath(pathAnnotation, null);
            this.registerRootParameters(context, element);
        } else if (element instanceof ExecutableElement) {
            this.name = element.getSimpleName().toString();
            this.path = this.sanitizeAnnotationPath(pathAnnotation, parentPath);
        }
        this.registerPathParameters(context);
        this.registerMatrixParameters(context);
        this.registerQueryParameters(context);
        this.qualifiedPath = this.createPathWithParameters(this.path);
    }

    private String createPathWithParameters(String path) {
        StringBuilder sb = new StringBuilder(path);
        String paramSeparator = ";";
        for (ParameterModel p : this.parameters) {
            if (p.getKind() != ParameterKind.MATRIX) continue;
            sb.append(paramSeparator).append(p.getName()).append("=").append("{").append(p.getName()).append("}");
        }
        paramSeparator = "?";
        for (ParameterModel p : this.parameters) {
            if (p.getKind() != ParameterKind.QUERY) continue;
            sb.append(paramSeparator).append(p.getName()).append("=").append("{").append(p.getName()).append("}");
            paramSeparator = "&";
        }
        return sb.toString();
    }

    private String sanitizeAnnotationPath(Path path, String parentPath) {
        String value;
        String string = value = path != null ? path.value() : null;
        String result = value != null ? (value.isEmpty() ? "" : (value.startsWith("/") ? (value.length() == 1 ? "" : this.sanitizePathParam(value.substring(1))) : this.sanitizePathParam(value))) : "";
        if (parentPath == null) {
            return "/" + result;
        }
        if (!parentPath.endsWith("/") && !result.isEmpty()) {
            return parentPath + "/" + result;
        }
        return parentPath + result;
    }

    private String sanitizePathParam(String value) {
        StringBuilder sb = new StringBuilder();
        String[] paramList = value.split("/");
        for (int i = 0; i < paramList.length; ++i) {
            if (paramList[i].isEmpty()) continue;
            if (paramList[i].startsWith("{")) {
                int paramConfig = paramList[i].indexOf(":");
                String sanitizedParam = paramConfig > 0 ? paramList[i].substring(0, paramConfig).trim() + "}" : paramList[i];
                sb.append(sanitizedParam);
            } else {
                sb.append(paramList[i]);
            }
            if (i >= paramList.length - 1) continue;
            sb.append("/");
        }
        return sb.toString();
    }

    private void addParameter(ProcessorContext context, String paramName, Element paramElement, ParameterKind kind) {
        String paramType;
        if (paramElement != null) {
            boolean isCollection = paramElement.asType().getKind() == TypeKind.ARRAY;
            Class javaType = ElementUtil.classFromType((Types)context.getTypes(), (TypeMirror)paramElement.asType());
            paramType = ElementUtil.classToXmlType((Class)javaType, (boolean)isCollection);
        } else {
            paramType = ElementUtil.classToXmlType(Object.class, (boolean)false);
        }
        ParameterModel parameter = new ParameterModel(paramName, paramType, kind);
        this.parameters.add(parameter);
    }

    private <A extends Annotation> Map<String, Element> getParamMap(Class<A> annotationClass) {
        List<? extends VariableElement> paramElements;
        HashMap<String, Element> paramMap = new HashMap<String, Element>();
        if (ROOT.equals(this.name)) {
            TypeElement classElement = (TypeElement)this.type;
            paramElements = ElementFilter.fieldsIn(classElement.getEnclosedElements());
        } else {
            ExecutableElement methodElement = (ExecutableElement)this.type;
            paramElements = methodElement.getParameters();
        }
        for (Element element : paramElements) {
            String value;
            A annotation = element.getAnnotation(annotationClass);
            if (annotation == null) continue;
            try {
                Method valueMethod = annotationClass.getMethod("value", new Class[0]);
                value = (String)valueMethod.invoke(annotation, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                throw new RuntimeException("Invalid method", ex);
            }
            paramMap.put(value, element);
        }
        return paramMap;
    }

    private void registerRootParameters(ProcessorContext context, Element element) {
        List<ExecutableElement> methods = ElementFilter.methodsIn(element.getEnclosedElements());
        for (ExecutableElement method : methods) {
            if (method.getAnnotation(Path.class) != null || method.getAnnotation(GET.class) == null && method.getAnnotation(POST.class) == null && method.getAnnotation(PUT.class) == null && method.getAnnotation(DELETE.class) == null) continue;
            ResourceModel innerMethod = new ResourceModel(context, method, this.path);
            this.parameters.addAll(innerMethod.getParameters());
        }
    }

    private void registerPathParameters(ProcessorContext context) {
        String[] pathList;
        ArrayList<String> pathParameters = new ArrayList<String>();
        for (String p : pathList = this.path.split("/")) {
            if (!p.startsWith("{")) continue;
            int paramClose = p.indexOf("}");
            if (paramClose > 0) {
                pathParameters.add(p.substring(1, paramClose).trim());
                continue;
            }
            context.getMessager().printMessage(Diagnostic.Kind.ERROR, "Invalid path param '" + this.path + "'", this.type);
        }
        Map<String, Element> pathParamMap = this.getParamMap(PathParam.class);
        for (String p : pathParameters) {
            this.addParameter(context, p, pathParamMap.get(p), ParameterKind.TEMPLATE);
        }
    }

    private void registerMatrixParameters(ProcessorContext context) {
        Map<String, Element> pathParamMap = this.getParamMap(MatrixParam.class);
        for (Map.Entry<String, Element> p : pathParamMap.entrySet()) {
            this.addParameter(context, p.getKey(), p.getValue(), ParameterKind.MATRIX);
        }
    }

    private void registerQueryParameters(ProcessorContext context) {
        Map<String, Element> pathParamMap = this.getParamMap(QueryParam.class);
        for (Map.Entry<String, Element> p : pathParamMap.entrySet()) {
            this.addParameter(context, p.getKey(), p.getValue(), ParameterKind.QUERY);
        }
    }

    public Element getType() {
        return this.type;
    }

    public Set<ParameterModel> getParameters() {
        return Collections.unmodifiableSet(this.parameters);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public String getQualifiedPath() {
        return this.qualifiedPath;
    }

    public void setQualifiedPath(String qualifiedPath) {
        this.qualifiedPath = qualifiedPath;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.qualifiedPath == null ? 0 : this.qualifiedPath.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceModel other = (ResourceModel)obj;
        return !(this.qualifiedPath == null ? other.qualifiedPath != null : !this.qualifiedPath.equals(other.qualifiedPath));
    }

    public String toString() {
        return "ResourceModel [type=" + this.type + ", name=" + this.name + ", path=" + this.path + ", qualifiedPath=" + this.qualifiedPath + ", parameters=" + this.parameters + "]";
    }
}

