/*
 * Decompiled with CFR 0.152.
 */
package com.aurea.sonic.esb.connect.processor.model;

import com.aurea.sonic.esb.annotation.util.ElementUtil;
import com.aurea.sonic.esb.annotation.util.ProcessorContext;
import com.aurea.sonic.esb.connect.annotation.SonicConnect;
import com.aurea.sonic.esb.connect.processor.model.ResourceModel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.StandardLocation;
import javax.ws.rs.Path;

public class ConnectModel {
    private final Element type;
    private final String className;
    private String name;
    private String tags;
    private String baseUrl;
    private boolean client;
    private boolean xqAware;
    private String springConfig;
    private final Set<ResourceModel> resources = new LinkedHashSet<ResourceModel>();

    public ConnectModel(ProcessorContext context, Element element) {
        this.type = element;
        TypeElement classElement = (TypeElement)element;
        this.className = classElement.getQualifiedName().toString();
        SonicConnect serviceAnnotation = element.getAnnotation(SonicConnect.class);
        this.name = !"".equals(serviceAnnotation.name()) ? serviceAnnotation.name() : classElement.getSimpleName().toString();
        this.tags = serviceAnnotation.tags();
        this.baseUrl = serviceAnnotation.baseUrl();
        this.client = serviceAnnotation.client();
        this.xqAware = ElementUtil.implementsInterface((Types)context.getTypes(), (Elements)context.getElements(), (TypeMirror)classElement.asType(), (String)"com.progress.sonic.esb.camel.XQInitContextAware");
        if (!serviceAnnotation.springConfigFilePath().isEmpty()) {
            String springConfigFilePath = serviceAnnotation.springConfigFilePath();
            try {
                this.setSpringConfig(this.loadSpringConfiguration(context.getFiler(), springConfigFilePath));
            }
            catch (IOException e) {
                context.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("Cannot read Spring configuration from %s, error message: %s", springConfigFilePath, e.getMessage()), element);
            }
        }
        ResourceModel rootResource = new ResourceModel(context, classElement, null);
        this.resources.add(rootResource);
        List<ExecutableElement> methods = ElementFilter.methodsIn(classElement.getEnclosedElements());
        for (ExecutableElement method : methods) {
            ResourceModel resource;
            Path methodPath = method.getAnnotation(Path.class);
            if (methodPath == null || "".equals(methodPath.value()) || this.resources.contains(resource = new ResourceModel(context, method, rootResource.getPath()))) continue;
            this.resources.add(resource);
        }
    }

    private String loadSpringConfiguration(Filer filer, String springConfigFilePath) throws IOException {
        try (InputStream inputStream = filer.getResource(StandardLocation.CLASS_OUTPUT, "", springConfigFilePath).openInputStream();){
            int readByte;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((readByte = inputStream.read()) != -1) {
                baos.write(readByte);
            }
            String string = baos.toString(StandardCharsets.UTF_8.name());
            return string;
        }
    }

    public Element getType() {
        return this.type;
    }

    public Set<ResourceModel> getResources() {
        return Collections.unmodifiableSet(this.resources);
    }

    public String getClassName() {
        return this.className;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTags() {
        return this.tags;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public boolean isClient() {
        return this.client;
    }

    public void setClient(boolean client) {
        this.client = client;
    }

    public boolean isXqAware() {
        return this.xqAware;
    }

    public void setXqAware(boolean xqAware) {
        this.xqAware = xqAware;
    }

    public String getSpringConfig() {
        return this.springConfig;
    }

    public void setSpringConfig(String springConfigFilePath) {
        this.springConfig = springConfigFilePath;
    }

    public String toString() {
        return "ConnectModel [type=" + this.type + ", className=" + this.className + ", name=" + this.name + ", tags=" + this.tags + ", baseUrl=" + this.baseUrl + ", client=" + this.client + ", xqAware=" + this.xqAware + ", springConfigFilePath=" + this.springConfig + ", resources=" + this.resources + "]";
    }
}

