/*
 * Decompiled with CFR 0.152.
 */
package com.aurea.sonic.esb.connect.processor;

import com.aurea.sonic.esb.annotation.util.ProcessorContext;
import com.aurea.sonic.esb.annotation.util.VelocityConfigurator;
import com.aurea.sonic.esb.connect.processor.model.ConnectModel;
import com.aurea.sonic.esb.connect.processor.model.ResourceModel;
import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.List;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;

public class ConnectServiceGenerator {
    private final ProcessorContext context;
    private static final String ESPOSE_ESB_TEMPLATE = "templates/expose/esb.vm";
    private static final String EXPOSE_PROPERTIES_TEMPLATE = "templates/expose/properties.vm";
    private static final String INVOKE_ESB_TEMPLATE = "templates/invoke/esb.vm";
    private static final String INVOKE_PROPERTIES_TEMPLATE = "templates/invoke/properties.vm";
    private static final String CONFIG_SPRING_TEMPLATE = "templates/config/spring.vm";
    private static final String CONNECT_FOLDER = "sonicesb.connect";
    private static final StandardLocation OUTPUT_LOCATION = StandardLocation.SOURCE_OUTPUT;

    public ConnectServiceGenerator(ProcessorContext context) {
        this.context = context;
        VelocityConfigurator.init();
    }

    public boolean generateService(ConnectModel service) {
        try {
            if (service.isClient()) {
                this.generateInvokeService(service);
            } else {
                this.generateExposeService(service);
            }
        }
        catch (Exception ex) {
            this.addError(service.getType(), "Error while generating '" + service.getClassName() + "' SonicConnect resources: " + ex.getMessage(), new Object[0]);
            return false;
        }
        return true;
    }

    public void generateSpringConfig(List<ConnectModel> services) {
        try {
            String configFolder = "sonicesb.connect.config";
            boolean hasServer = false;
            for (ConnectModel service : services) {
                if (service.isClient()) continue;
                hasServer = true;
                break;
            }
            VelocityContext model = ConnectServiceGenerator.retrieveModel();
            model.put("services", services);
            model.put("server", (Object)hasServer);
            Template springTemplate = Velocity.getTemplate((String)CONFIG_SPRING_TEMPLATE);
            FileObject springResource = this.context.getFiler().createResource(OUTPUT_LOCATION, "sonicesb.connect.config", "spring.xml", new Element[0]);
            try (Writer out = springResource.openWriter();){
                springTemplate.merge((Context)model, out);
            }
        }
        catch (Exception ex) {
            this.addError(null, "Error while generating SonicConnect spring.xml resource: " + ex.getMessage(), new Object[0]);
        }
    }

    private void generateInvokeService(ConnectModel service) throws Exception {
        String serviceFolder = "sonicesb.connect.services.invoke";
        VelocityContext model = ConnectServiceGenerator.initModel(service);
        model.put("resources", service.getResources());
        Template propertiesTemplate = Velocity.getTemplate((String)INVOKE_PROPERTIES_TEMPLATE);
        this.mergePropertiesTemplate(model, propertiesTemplate, service, "sonicesb.connect.services.invoke");
        for (ResourceModel resource : service.getResources()) {
            model.put("resource", (Object)resource);
            Template esbTemplate = Velocity.getTemplate((String)INVOKE_ESB_TEMPLATE);
            FileObject esbResource = this.context.getFiler().createResource(OUTPUT_LOCATION, "sonicesb.connect.services.invoke", service.getClassName() + "." + resource.getName() + ".esbcamel", new Element[0]);
            Writer out = esbResource.openWriter();
            try {
                esbTemplate.merge((Context)model, out);
            }
            finally {
                if (out == null) continue;
                out.close();
            }
        }
    }

    private void generateExposeService(ConnectModel service) throws Exception {
        String serviceFolder = "sonicesb.connect.services.expose";
        VelocityContext model = ConnectServiceGenerator.initModel(service);
        Template esbTemplate = Velocity.getTemplate((String)ESPOSE_ESB_TEMPLATE);
        FileObject esbResource = this.context.getFiler().createResource(OUTPUT_LOCATION, "sonicesb.connect.services.expose", service.getClassName() + ".esbcamel", new Element[0]);
        try (Writer out = esbResource.openWriter();){
            esbTemplate.merge((Context)model, out);
        }
        Template propertiesTemplate = Velocity.getTemplate((String)EXPOSE_PROPERTIES_TEMPLATE);
        this.mergePropertiesTemplate(model, propertiesTemplate, service, "sonicesb.connect.services.expose");
    }

    private void mergePropertiesTemplate(VelocityContext model, Template propertiesTemplate, ConnectModel service, String serviceFolder) throws IOException {
        FileObject propertiesResource = this.context.getFiler().createResource(OUTPUT_LOCATION, serviceFolder, service.getClassName() + ".properties", new Element[0]);
        try (Writer out = propertiesResource.openWriter();){
            propertiesTemplate.merge((Context)model, out);
        }
    }

    private static VelocityContext initModel(ConnectModel service) {
        VelocityContext model = ConnectServiceGenerator.retrieveModel();
        model.put("class", (Object)service.getClassName());
        model.put("tags", (Object)service.getTags());
        model.put("uri-alias", (Object)service.getName());
        model.put("base-url", (Object)service.getBaseUrl());
        return model;
    }

    private static VelocityContext retrieveModel() {
        VelocityContext model = new VelocityContext();
        model.put("tool", (Object)"connect-processor");
        model.put("time-stamp", (Object)new Date().toString());
        model.put("placeholder-begins", (Object)"${");
        model.put("placeholder-ends", (Object)"}");
        return model;
    }

    private void addError(Element element, String message, Object ... args) {
        String formattedMessage = String.format(message, args);
        this.context.getMessager().printMessage(Diagnostic.Kind.ERROR, formattedMessage, element);
    }
}

