/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.service.common.impl;

import com.sonicsw.esb.service.common.util.Check;
import com.sonicsw.esb.service.common.util.CheckArg;
import com.sonicsw.esb.service.common.util.variables.VariableFactory;
import com.sonicsw.esb.service.common.util.variables.VariableResolver;
import com.sonicsw.mf.common.IComponentContext;
import com.sonicsw.mf.common.config.IAttributeSet;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class ContainerDeploymentParameterVariableResolver
implements VariableResolver,
VariableFactory {
    private static final String SCHEME = "container";
    private static final Logger logger = Logger.getLogger((String)(VariableResolver.class.getName() + '.' + "container"));
    private final IComponentContext componentContext;

    public ContainerDeploymentParameterVariableResolver() {
        this.componentContext = null;
    }

    public ContainerDeploymentParameterVariableResolver(IComponentContext componentContext) {
        this.componentContext = componentContext;
    }

    public String getScheme() {
        return SCHEME;
    }

    @Override
    public String resolve(String variableStr) {
        IAttributeSet attrSet;
        CheckArg.notNull(variableStr, "variableStr");
        Check.isSet(this.componentContext, "componentContext");
        ContainerDeploymentParameterVariable var = (ContainerDeploymentParameterVariable)this.getVariable(variableStr);
        String name = var.getPropertyName();
        IAttributeSet deploymentParameters = this.componentContext.getDeploymentParameters();
        if (deploymentParameters != null && (attrSet = (IAttributeSet)deploymentParameters.getAttribute(name)) != null) {
            return (String)attrSet.getAttribute("VALUE");
        }
        return null;
    }

    @Override
    public VariableFactory.Variable getVariable(String variableStr) {
        return new ContainerDeploymentParameterVariable(variableStr);
    }

    public VariableFactory.Variable createVariable(String propertyName) {
        String variableStr = "container:" + propertyName;
        return new ContainerDeploymentParameterVariable(variableStr);
    }

    public static class ContainerDeploymentParameterVariable
    implements VariableFactory.Variable {
        private final String propertyName;
        private final String variableStr;

        ContainerDeploymentParameterVariable(String variableStr) {
            StringTokenizer parts = new StringTokenizer(variableStr, ":");
            if (parts.countTokens() != 2 || !ContainerDeploymentParameterVariableResolver.SCHEME.equals(parts.nextToken())) {
                throw new IllegalArgumentException("Malformed message variable string: '" + variableStr + "'. Expected format is " + ContainerDeploymentParameterVariableResolver.SCHEME + "':param'.");
            }
            this.propertyName = parts.nextToken();
            this.variableStr = variableStr;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public String toString() {
            return this.variableStr;
        }
    }
}

