/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.service.common.impl;

import com.sonicsw.esb.service.common.SFCDiagnosticContext;
import com.sonicsw.esb.service.common.impl.core.MetricsRegistrar;
import com.sonicsw.esb.service.common.impl.events.SFCServiceLifecycleEvent;
import com.sonicsw.esb.service.common.metrics.NotificationsHandler;
import com.sonicsw.mf.common.IComponentContext;
import com.sonicsw.mf.common.info.INotificationInfo;
import com.sonicsw.mf.common.info.InfoFactory;
import com.sonicsw.mf.common.runtime.INotification;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;

class NotificationsHandlerImpl
implements NotificationsHandler,
ApplicationListener {
    private static final Logger logger = Logger.getLogger(NotificationsHandler.class);
    private static final Map notifications = new HashMap();
    private final MetricsRegistrar registrar;
    private final IComponentContext componentContext;
    private boolean canRegister = true;

    public NotificationsHandlerImpl(MetricsRegistrar registrar, IComponentContext componentContext) {
        this.registrar = registrar;
        this.componentContext = componentContext;
    }

    @Override
    public void registerNotification(String name) {
        this.registerNotification(name, "");
    }

    @Override
    public void registerNotification(String name, String description) {
        if (!this.canRegister) {
            throw new IllegalStateException("Notifications can no longer be registered.");
        }
        if (!notifications.containsKey(name)) {
            int ix = name.indexOf(46);
            if (ix < 0) {
                throw new IllegalArgumentException("Notification name must be of the form 'category.name'. Unable to determine category for: " + name);
            }
            String category = name.substring(0, ix);
            String event = name.substring(ix + 1);
            INotificationInfo info = InfoFactory.createNotificationInfo((short)2, (String)category, (String)event, (String)"");
            notifications.put(name, info);
            this.registrar.addNotification(info);
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Ignoring notification '" + name + "' - a notification has already been registered with that name."));
        }
    }

    @Override
    public void sendConfigNotification(String name) {
        this.sendConfigNotification(name, Collections.EMPTY_MAP);
    }

    @Override
    public void sendConfigNotification(String name, Map attributes) {
        this.sendNotification(name, attributes, 4);
    }

    @Override
    public void sendInfoNotification(String name) {
        this.sendInfoNotification(name, Collections.EMPTY_MAP);
    }

    @Override
    public void sendInfoNotification(String name, Map attributes) {
        this.sendNotification(name, attributes, 3);
    }

    @Override
    public void sendWarningNotification(String name) {
        this.sendWarningNotification(name, Collections.EMPTY_MAP);
    }

    @Override
    public void sendWarningNotification(String name, Map attributes) {
        this.sendNotification(name, attributes, 2);
    }

    @Override
    public void sendSevereNotification(String name) {
        this.sendSevereNotification(name, Collections.EMPTY_MAP);
    }

    @Override
    public void sendSevereNotification(String name, Map attributes) {
        this.sendNotification(name, attributes, 1);
    }

    private void sendNotification(String name, Map attributes, int severity) {
        if (!notifications.containsKey(name)) {
            throw new IllegalArgumentException("Notification '" + name + "' has not been registered.");
        }
        int ix = name.indexOf(46);
        String category = name.substring(0, ix);
        String event = name.substring(ix + 1);
        INotification notification = this.componentContext.createNotification((short)2, category, event, severity);
        this.addAttributes(notification, attributes);
        this.addAttributes(notification, SFCDiagnosticContext.asMap());
        logger.debug((Object)("Sending notification: " + name));
        this.componentContext.sendNotification(notification);
    }

    private INotification addAttributes(INotification notification, Map attribs) {
        for (String key : attribs.keySet()) {
            notification.setAttribute(key, attribs.get(key));
        }
        return notification;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof SFCServiceLifecycleEvent && 0 == ((SFCServiceLifecycleEvent)event).getEventType()) {
            this.disableRegistration();
        }
    }

    public void disableRegistration() {
        this.canRegister = false;
    }

    static void clearRegisteredNotifications() {
        notifications.clear();
    }
}

