/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.service.common.impl;

import com.sonicsw.esb.service.common.SFCInitializationContext;
import com.sonicsw.esb.service.common.SFCService;
import com.sonicsw.esb.service.common.SFCServiceContext;
import com.sonicsw.esb.service.common.impl.SFCServiceState;
import com.sonicsw.xq.XQEnvelope;
import com.sonicsw.xq.XQServiceException;
import org.apache.log4j.Logger;

class ServiceLifecycleDecorator
implements SFCService {
    private static final Logger logger = Logger.getLogger(SFCService.class);
    private SFCService target;
    private SFCServiceState currentState = SFCServiceState.UNINITIALIZED;
    private Exception lastException = null;

    ServiceLifecycleDecorator() {
    }

    @Override
    public void doInit(SFCInitializationContext context) throws XQServiceException {
        if (this.allowTransition(SFCServiceState.UNINITIALIZED, SFCServiceState.STOPPED)) {
            try {
                this.target.doInit(context);
                logger.info((Object)"Service has been initialized.");
                this.setCurrentState(SFCServiceState.STOPPED);
            }
            catch (XQServiceException excp) {
                this.lastException = excp;
                throw excp;
            }
            catch (RuntimeException excp) {
                this.lastException = excp;
                throw excp;
            }
        }
    }

    @Override
    public void doStart() throws XQServiceException {
        if (this.allowTransition(SFCServiceState.STOPPED, SFCServiceState.STARTED)) {
            try {
                logger.info((Object)"Starting service...");
                this.target.doStart();
                this.setCurrentState(SFCServiceState.STARTED);
                logger.info((Object)"Service has been started.");
            }
            catch (XQServiceException excp) {
                this.lastException = excp;
                throw excp;
            }
            catch (RuntimeException excp) {
                this.lastException = excp;
                throw excp;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doStop() throws XQServiceException {
        if (this.allowTransition(SFCServiceState.STARTED, SFCServiceState.STOPPED)) {
            try {
                logger.info((Object)"Stopping service...");
                this.target.doStop();
            }
            catch (Exception excp) {
                logger.error((Object)"Error stopping service", (Throwable)excp);
            }
            finally {
                this.setCurrentState(SFCServiceState.STOPPED);
                logger.info((Object)"Service has been stopped.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doDestroy() throws XQServiceException {
        if (this.currentState != SFCServiceState.UNINITIALIZED) {
            try {
                logger.info((Object)"Destroying service...");
                this.target.doDestroy();
            }
            finally {
                logger.info((Object)"Service has been destroyed.");
                this.setCurrentState(SFCServiceState.UNINITIALIZED);
            }
        }
    }

    @Override
    public void doService(SFCServiceContext context, XQEnvelope envelope) throws XQServiceException {
        this.validateCurrentStateIs(SFCServiceState.STARTED);
        this.target.doService(context, envelope);
    }

    private void setCurrentState(SFCServiceState state) {
        this.currentState = state;
        this.lastException = null;
    }

    private boolean allowTransition(SFCServiceState sourceState, SFCServiceState targetState) {
        if (this.currentState == targetState) {
            logger.debug((Object)("Will not transition from state '" + this.currentState + "' to itself."));
            return false;
        }
        this.validateCurrentStateIs(sourceState);
        if (!this.currentState.canTransitionTo(targetState)) {
            this.throwInvalidStateException("Cannot transition from state '" + this.currentState + "' to '" + targetState + "'");
        }
        return true;
    }

    private void validateCurrentStateIs(SFCServiceState expectedState) {
        if (this.currentState != expectedState) {
            this.throwInvalidStateException("Service not in expected state '" + expectedState + "'. Current state is '" + this.currentState + "'");
        }
    }

    private Exception throwInvalidStateException(String msg) {
        IllegalStateException excp = new IllegalStateException(msg);
        if (this.lastException != null) {
            excp.initCause(this.lastException);
        }
        throw excp;
    }

    public void setTarget(SFCService target) {
        this.target = target;
    }
}

