/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.service.common.impl;

import com.sonicsw.esb.service.common.util.variables.VariableFactory;
import com.sonicsw.esb.service.common.util.variables.VariableResolver;
import org.apache.log4j.Logger;

public class TestResolver
implements VariableResolver,
VariableFactory {
    private static final String SCHEME = "test";
    private static final Logger logger = Logger.getLogger((String)(VariableResolver.class.getName() + '.' + "test"));

    public String getScheme() {
        return SCHEME;
    }

    @Override
    public VariableFactory.Variable getVariable(String variableStr) {
        return new ValueVariable(variableStr);
    }

    public VariableFactory.Variable createVariable(String value) {
        return new ValueVariable("test:" + value);
    }

    @Override
    public String resolve(String variableStr) {
        ValueVariable var = (ValueVariable)this.getVariable(variableStr);
        return var.getValue();
    }

    public class ValueVariable
    implements VariableFactory.Variable {
        private final String value;
        private final String variableStr;

        ValueVariable(String variableStr) {
            int ix = variableStr.indexOf(58);
            if (ix <= 0) {
                throw new IllegalArgumentException("Malformed test URL variable string: '" + variableStr + "'. No value found. " + "Expected format is 'test:value'.'");
            }
            this.value = variableStr.substring(ix + 1);
            this.variableStr = variableStr;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.variableStr;
        }
    }
}

