/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.service.common.ramps;

import com.sonicsw.esb.service.common.SFCInitializationContext;
import com.sonicsw.esb.service.common.ramps.IConnectionFactory;
import com.sonicsw.esb.service.common.ramps.ServiceRestarterJob;
import com.sonicsw.esb.service.common.ramps.impl.QuartzUtils;
import com.sonicsw.xq.XQMessageException;
import java.util.Date;
import org.apache.log4j.Logger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;

public final class ServiceRestarter {
    private static final Logger LOGGER = Logger.getLogger(ServiceRestarter.class);
    private final SFCInitializationContext context_;
    private final Scheduler scheduler_;
    private static final String GROUP_NAME = "SonicESB Ramps ServiceRestarter";

    public ServiceRestarter(SFCInitializationContext _context) {
        this.context_ = _context;
        try {
            this.scheduler_ = QuartzUtils.getScheduler(5);
            this.scheduler_.start();
        }
        catch (SchedulerException e) {
            IllegalStateException ise = new IllegalStateException("Cannot create a scheduler for the ServiceRestarter");
            ise.initCause(e);
            throw ise;
        }
    }

    public void register(IConnectionFactory _connectionFactory, long _retryInterval) throws XQMessageException {
        String serviceName = this.context_.getServiceName();
        JobDetail jobDetail = new JobDetail(serviceName, GROUP_NAME, ServiceRestarterJob.class);
        JobDataMap map = new JobDataMap();
        map.put((Object)"XQInitContext", (Object)this.context_);
        map.put((Object)"IConnectionFactory", (Object)_connectionFactory);
        jobDetail.setJobDataMap(map);
        Date startDate = new Date(new Date().getTime() + _retryInterval);
        SimpleTrigger trigger = new SimpleTrigger("ServiceRestarterTimer", GROUP_NAME, startDate, null, -1, _retryInterval);
        try {
            this.scheduler_.scheduleJob(jobDetail, (Trigger)trigger);
        }
        catch (ObjectAlreadyExistsException e) {
        }
        catch (SchedulerException e) {
            throw new XQMessageException("Fatal error scheduling an automatic service restart.", (Throwable)e);
        }
    }

    public void start() {
        this.removeJob(this.context_.getServiceName());
    }

    public void destroy() {
        this.removeJob(this.context_.getServiceName());
    }

    private void removeJob(String _jobName) {
        try {
            this.scheduler_.deleteJob(_jobName, GROUP_NAME);
        }
        catch (SchedulerException e) {
            LOGGER.warn((Object)("Cannot remove job with name " + _jobName), (Throwable)e);
        }
    }
}

