/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.service.common.ramps;

import com.sonicsw.esb.service.common.SFCInitializationContext;
import com.sonicsw.esb.service.common.ramps.IConnectionContext;
import com.sonicsw.esb.service.common.ramps.IConnectionFactory;
import com.sonicsw.esb.service.common.ramps.InvalidConnectionException;
import com.sonicsw.xq.XQMessageException;
import com.sonicsw.xq.XQServiceException;
import org.apache.log4j.Logger;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SchedulerException;
import org.quartz.StatefulJob;

public final class ServiceRestarterJob
implements StatefulJob {
    private static final Logger LOGGER = Logger.getLogger(ServiceRestarterJob.class);
    public static final String XQINITCONTEXT_KEY = "XQInitContext";
    public static final String CONNECTION_FACTORY_KEY = "IConnectionFactory";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext _context) throws JobExecutionException {
        SFCInitializationContext context = (SFCInitializationContext)_context.getJobDetail().getJobDataMap().get((Object)XQINITCONTEXT_KEY);
        IConnectionFactory connectionFactory = (IConnectionFactory)_context.getJobDetail().getJobDataMap().get((Object)CONNECTION_FACTORY_KEY);
        boolean success = false;
        try {
            IConnectionContext connection = connectionFactory.createConnection(context);
            try {
                connection.activate();
                try {
                    success = context.getLifeCycle().startService();
                }
                finally {
                    connection.deactivate(success);
                }
            }
            finally {
                connectionFactory.destroyConnection(connection, success);
            }
        }
        catch (XQMessageException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (XQServiceException e) {
            LOGGER.warn((Object)("Could not reestablish connection due to " + e.getMessage()));
            LOGGER.debug((Object)e);
        }
        catch (InvalidConnectionException e) {
            LOGGER.warn((Object)("Could not reestablish connection due to " + e.getMessage()));
            LOGGER.debug((Object)e);
        }
        if (success) {
            try {
                _context.getScheduler().deleteJob(_context.getJobDetail().getName(), _context.getJobDetail().getGroup());
            }
            catch (SchedulerException e) {
                throw new JobExecutionException((Throwable)e);
            }
        }
    }
}

