/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.service.common.ramps;

import com.sonicsw.esb.service.common.SFCInitializationContext;
import com.sonicsw.esb.service.common.SFCServiceContext;
import com.sonicsw.esb.service.common.ramps.AbstractSyncRamp;
import com.sonicsw.esb.service.common.ramps.ICompositeConnectionContext;
import com.sonicsw.esb.service.common.ramps.IConnectionContext;
import com.sonicsw.esb.service.common.ramps.IDataSink;
import com.sonicsw.esb.service.common.ramps.InvalidConnectionException;
import com.sonicsw.esb.service.common.ramps.MappingException;
import com.sonicsw.esb.service.common.ramps.impl.ExitToServiceException;
import com.sonicsw.esb.service.common.ramps.utils.Utils;
import com.sonicsw.xq.XQEnvelope;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQMessageException;
import com.sonicsw.xq.XQServiceException;

public final class SyncOffRamp
extends AbstractSyncRamp {
    private IDataSink dataSink_;
    private boolean continueFlow_ = true;

    public SyncOffRamp(String _serviceGroupName) {
        super(_serviceGroupName);
    }

    public SyncOffRamp(IDataSink _sink, String _serviceGroupName) {
        this(_serviceGroupName);
        this.setDataSink(_sink);
    }

    public void setDataSink(IDataSink _sink) {
        this.dataSink_ = _sink;
        this.getErrorHandler().setFaultInfoProvider(this.dataSink_);
        this.getErrorHandler().setConnectionFactory(this.dataSink_);
    }

    public void init(SFCInitializationContext _ctx) throws XQServiceException {
        this.internalInit(_ctx);
        this.continueFlow_ = Boolean.valueOf(_ctx.getParameters().getParameter("ContinueFlow", String.valueOf(this.continueFlow_)));
        Utils.delegateCall(this.dataSink_, "init", new Class[]{SFCInitializationContext.class}, new Object[]{_ctx});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(SFCServiceContext _ctx, XQEnvelope _envelope) throws XQMessageException, XQServiceException {
        this.validateCurrentState();
        XQMessage msg = _envelope.getMessage();
        boolean isRetry = SyncOffRamp.getInitialRetryValue(msg);
        this.stopRequested_ = false;
        boolean success = false;
        boolean blockForCompletion = this.getErrorHandler().getBlockForCompletion();
        if (blockForCompletion) {
            this.addToBlocking();
        }
        try {
            do {
                IConnectionContext connection = this.getErrorHandler().createConnection(this.dataSink_, _ctx, msg);
                try {
                    do {
                        this.getErrorHandler().openConnection(connection, _ctx, msg);
                        try {
                            Object[] messsages;
                            IConnectionContext underlying = connection;
                            if (connection instanceof ICompositeConnectionContext) {
                                underlying = ((ICompositeConnectionContext)((Object)connection)).getUnderlying();
                            }
                            try {
                                messsages = this.dataSink_.getMessageMapper().mapForOfframp(msg, underlying, _ctx);
                                if (null == messsages || messsages.length == 0) {
                                    throw new XQMessageException("The incoming message did not produce any messages for the data sink.");
                                }
                            }
                            catch (MappingException e) {
                                throw new XQMessageException((Throwable)e);
                            }
                            try {
                                do {
                                    try {
                                        this.dataSink_.consume(underlying, messsages, isRetry);
                                        success = true;
                                    }
                                    catch (XQServiceException e) {
                                        this.getErrorHandler().handleException(_ctx, msg, connection, e);
                                    }
                                    finally {
                                        isRetry = true;
                                    }
                                } while (!success && !this.stopRequested_);
                            }
                            finally {
                                this.dataSink_.getMessageMapper().cleanup(underlying, messsages);
                            }
                        }
                        finally {
                            connection.deactivate(success);
                        }
                    } while (!success && !this.stopRequested_);
                }
                catch (InvalidConnectionException e) {
                    this.getErrorHandler().handleInvalidConnectionException(e);
                }
                finally {
                    this.dataSink_.destroyConnection(connection, success);
                }
            } while (!success && !this.stopRequested_);
            if (this.stopRequested_ && !success) {
                this.getErrorHandler().failureModeAbort_Service(_ctx, msg, null, null);
                return;
            }
        }
        catch (ExitToServiceException e) {
        }
        finally {
            if (blockForCompletion) {
                this.removeFromBlocking();
            }
        }
        if (this.continueFlow_ && success && _envelope.getAddresses().hasNext()) {
            XQMessage message = this.handleMessageRetaining(msg);
            _ctx.addOutgoing(message);
        }
    }

    private void validateCurrentState() {
        if (null == this.dataSink_) {
            throw new IllegalStateException("No data sink is set.");
        }
        if (null == this.dataSink_.getMessageMapper()) {
            throw new IllegalStateException("The data sink has no mapper set.");
        }
    }
}

