/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.service.common.ramps.impl;

import com.sonicsw.esb.service.common.SFCParameters;
import com.sonicsw.esb.service.common.SFCServiceContext;
import com.sonicsw.esb.service.common.ramps.IConnectionContext;
import com.sonicsw.esb.service.common.ramps.IConnectionFactory;
import com.sonicsw.esb.service.common.ramps.IFaultInfoProvider;
import com.sonicsw.esb.service.common.ramps.InvalidConnectionException;
import com.sonicsw.esb.service.common.ramps.ServiceRestarter;
import com.sonicsw.esb.service.common.ramps.impl.ExitToServiceException;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQMessageException;
import com.sonicsw.xq.XQServiceException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public final class ErrorHandler {
    private static final Logger LOGGER = Logger.getLogger(ErrorHandler.class);
    private String failureMode_ = "RME";
    private long retryInterval_ = 60000L;
    private static final String[] FAILURE_MODES = new String[]{"RME", "Fault", "Retry", "Abort_Service", "Abort_ServiceWithRestart", "Abort_Container"};
    private static final Map FAILURE_METHODS = new HashMap(FAILURE_MODES.length);
    private volatile boolean stopRequested_;
    private IFaultInfoProvider faultInfoProvider_;
    private IConnectionFactory connectionFactory_;

    private static void addFailureMode(String _mode) throws NoSuchMethodException {
        FAILURE_METHODS.put(_mode, ErrorHandler.class.getDeclaredMethod("failureMode" + _mode, SFCServiceContext.class, XQMessage.class, IConnectionContext.class, XQServiceException.class));
    }

    public void init(SFCParameters _params) {
        this.failureMode_ = _params.getParameter("FailureMode", "RME");
        this.retryInterval_ = Long.parseLong(_params.getParameter("RetryTimeout", String.valueOf(this.retryInterval_)));
    }

    public void stop() {
        this.stopRequested_ = true;
    }

    public boolean getBlockForCompletion() {
        return "Retry".equals(this.failureMode_);
    }

    public void setFaultInfoProvider(IFaultInfoProvider _faultInfoProvider) {
        this.faultInfoProvider_ = _faultInfoProvider;
    }

    public void setConnectionFactory(IConnectionFactory _connectionFactory) {
        this.connectionFactory_ = _connectionFactory;
    }

    public void handleException(SFCServiceContext _ctx, XQMessage _msg, IConnectionContext _connection, XQServiceException _e) throws XQServiceException, XQMessageException, ExitToServiceException {
        if (null == _ctx) {
            throw new IllegalArgumentException("SFCServiceContext cannot be null.");
        }
        if (null == _msg) {
            throw new IllegalArgumentException("incoming XQMessage cannot be null.");
        }
        Method method = (Method)FAILURE_METHODS.get(this.failureMode_);
        if (null == method) {
            throw new IllegalStateException("Failure handling method must not be null");
        }
        try {
            method.invoke((Object)this, new Object[]{_ctx, _msg, _connection, _e});
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof XQServiceException) {
                throw (XQServiceException)e.getCause();
            }
            if (e.getCause() instanceof XQMessageException) {
                throw (XQMessageException)e.getCause();
            }
            if (e.getCause() instanceof ExitToServiceException) {
                throw (ExitToServiceException)e.getCause();
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new XQServiceException(e.getCause());
        }
        catch (IllegalAccessException e) {
            throw new XQMessageException((Throwable)e);
        }
    }

    private void failureModeRME(SFCServiceContext _ctx, XQMessage _msg, IConnectionContext _handle, XQServiceException _e) throws XQServiceException {
        throw _e;
    }

    private void failureModeFault(SFCServiceContext _ctx, XQMessage _msg, IConnectionContext _handle, XQServiceException _e) throws XQMessageException, ExitToServiceException {
        if (null != this.faultInfoProvider_) {
            _msg.setStringHeader("Error.ServiceType", _ctx.getServiceTypeName());
            _msg.setStringHeader("Error.ServiceName", _ctx.getProcessStepName());
            this.faultInfoProvider_.addFaultInfo(_msg, _handle, _e);
        }
        _ctx.addFault(_msg);
        throw new ExitToServiceException();
    }

    private void failureModeRetry(SFCServiceContext _ctx, XQMessage _msg, IConnectionContext _connection, XQServiceException _e) {
        String cause = _e == null ? "unknown" : _e.getMessage();
        LOGGER.warn((Object)("Sync ramp failure for service " + _ctx.getServiceName() + " due to '" + cause + "' . Will wait for " + this.retryInterval_ + " ms before retrying."));
        if (null != _e && LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Retry cause.", (Throwable)_e);
        }
        try {
            Thread.sleep(this.retryInterval_);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
    }

    public void failureModeAbort_Service(SFCServiceContext _ctx, XQMessage _msg, IConnectionContext _connection, XQServiceException _e) throws ExitToServiceException, XQMessageException {
        _ctx.getLifeCycle().abortService();
        throw new ExitToServiceException();
    }

    private void failureModeAbort_ServiceWithRestart(SFCServiceContext _ctx, XQMessage _msg, IConnectionContext _connection, XQServiceException _e) throws ExitToServiceException, XQMessageException {
        LOGGER.warn((Object)("Sync ramp failure for service " + _ctx.getServiceName() + ". The service is being restarted. Failure cause:\n"), (Throwable)_e);
        _ctx.getLifeCycle().abortService();
        ServiceRestarter restarter = new ServiceRestarter(_ctx);
        restarter.register(this.connectionFactory_, this.retryInterval_);
        throw new ExitToServiceException();
    }

    private void failureModeAbort_Container(SFCServiceContext _ctx, XQMessage _msg, IConnectionContext _connection, XQServiceException _e) throws ExitToServiceException {
        _ctx.getLifeCycle().abortContainer();
        throw new ExitToServiceException();
    }

    public IConnectionContext createConnection(IConnectionFactory _factory, SFCServiceContext _ctx, XQMessage _msg) throws XQMessageException, XQServiceException, ExitToServiceException {
        while (true) {
            try {
                IConnectionContext connection = _factory.createConnection(_ctx);
                if (null == connection) {
                    throw new IllegalStateException("Connection factory returned successfully but did not return a connection.");
                }
                return connection;
            }
            catch (XQServiceException e) {
                this.handleException(_ctx, _msg, null, e);
                if (!this.stopRequested_) continue;
                this.failureModeAbort_Service(_ctx, _msg, null, null);
                throw new ExitToServiceException();
            }
            break;
        }
    }

    public void openConnection(IConnectionContext _connection, SFCServiceContext _ctx, XQMessage _msg) throws XQMessageException, XQServiceException, ExitToServiceException, InvalidConnectionException {
        if (null == _connection) {
            throw new IllegalArgumentException("Connection must not be null.");
        }
        boolean blockForCompletion = this.getBlockForCompletion();
        boolean success = false;
        do {
            try {
                _connection.activate();
                success = true;
            }
            catch (XQServiceException e) {
                this.handleException(_ctx, _msg, _connection, e);
            }
        } while (!success && blockForCompletion && !this.stopRequested_);
        if (!success) {
            this.failureModeAbort_Service(_ctx, _msg, null, null);
            throw new ExitToServiceException();
        }
    }

    public void handleInvalidConnectionException(InvalidConnectionException _e) throws XQServiceException {
        if (!"Retry".equals(this.failureMode_)) {
            throw new XQServiceException((Throwable)_e);
        }
    }

    static {
        try {
            for (int i = 0; i < FAILURE_MODES.length; ++i) {
                ErrorHandler.addFailureMode(FAILURE_MODES[i]);
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }
}

