/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.service.common.ramps.pools;

import com.sonicsw.esb.service.common.ramps.IConnectionContext;
import com.sonicsw.esb.service.common.ramps.pools.AbstractKeyedPoolConnectionFactory;
import com.sonicsw.esb.service.common.ramps.pools.IPoolableConnectionContext;
import org.apache.commons.pool.KeyedPoolableObjectFactory;

public final class KeyedPoolableConnectionFactory
implements KeyedPoolableObjectFactory {
    public Object makeObject(Object _key) throws Exception {
        this.validateKey(_key);
        AbstractKeyedPoolConnectionFactory.PoolKey key = (AbstractKeyedPoolConnectionFactory.PoolKey)_key;
        IConnectionContext connection = key.getFactory().createConnection(key.getContext());
        connection.activate();
        return connection;
    }

    public void activateObject(Object _key, Object _connection) throws Exception {
    }

    public boolean validateObject(Object _key, Object _connection) {
        if (_connection instanceof IPoolableConnectionContext) {
            return ((IPoolableConnectionContext)_connection).validate();
        }
        return true;
    }

    public void passivateObject(Object _key, Object _connection) throws Exception {
    }

    public void destroyObject(Object _key, Object _connection) throws Exception {
        if (!(_connection instanceof IConnectionContext)) {
            throw new IllegalArgumentException("Not a connection object");
        }
        this.validateKey(_key);
        AbstractKeyedPoolConnectionFactory.PoolKey key = (AbstractKeyedPoolConnectionFactory.PoolKey)_key;
        ((IConnectionContext)_connection).deactivate(true);
        key.getFactory().destroyConnection((IConnectionContext)_connection, true);
    }

    private void validateKey(Object _key) {
        if (!(_key instanceof AbstractKeyedPoolConnectionFactory.PoolKey)) {
            throw new IllegalArgumentException("The key provided is not a pool key from the ramps.");
        }
    }
}

