/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.service.common.util.message.impl;

import com.sonicsw.esb.service.common.util.message.EsbMsgUtilsContext;
import com.sonicsw.esb.service.common.util.message.EsbMsgUtilsException;
import com.sonicsw.esb.service.common.util.message.XmlToXQMessage;
import com.sonicsw.tools.esbmsg.namespace.BodyType;
import com.sonicsw.tools.esbmsg.namespace.EsbmsgDocument;
import com.sonicsw.tools.esbmsg.namespace.HeaderType;
import com.sonicsw.tools.esbmsg.namespace.PartType;
import com.sonicsw.tools.esbmsg.namespace.PropertyType;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQPart;
import com.sonicsw.xqimpl.envelope.XQMessageFactoryImpl;
import com.sonicsw.xqimpl.util.DOMUtils;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import javax.activation.MimeType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class XmlOldToXQMessageImpl
implements XmlToXQMessage {
    private Map m_headerAdapterMap = new HashMap();
    private Map m_unProcessedheaders = new HashMap();
    private static final String URI = "http://sonicsw.com/tools/esbmsg/namespace";
    protected JMSHeaderAdapter defaultAdapter = new NullAdapter();

    public XmlOldToXQMessageImpl() {
        this.sethdrMap();
    }

    private void sethdrMap() {
        this.m_headerAdapterMap.put("JMSPriority", new IntAdapter());
        this.m_headerAdapterMap.put("JMSDeliveryMode", new IntAdapter());
        this.m_headerAdapterMap.put("JMSExpiration", new LongAdapter());
        this.m_headerAdapterMap.put("JMSRedelivered", new BooleanAdapter());
        this.m_headerAdapterMap.put("JMSTimestamp", new LongAdapter());
    }

    @Override
    public boolean isESBMessage(Element documentElement) {
        boolean result = false;
        try {
            EsbmsgDocument esbDoc = this.getEsbmsgDocument(documentElement);
            result = esbDoc.validate();
        }
        catch (EsbMsgUtilsException e) {
            return false;
        }
        return result;
    }

    @Override
    public XQMessage createXQMessage(Element documentElement) throws EsbMsgUtilsException {
        return this.createXQMessageInternal(documentElement);
    }

    private XQMessage createXQMessageInternal(Element documentElement) throws EsbMsgUtilsException {
        EsbMsgUtilsContext ctx = new EsbMsgUtilsContext("Convert xml as Element to XQMessage");
        ctx.setObjectType("Element");
        ctx.setOperation("Get XQMessage from - esbmsg as Element");
        ctx.setElement(documentElement);
        try {
            EsbmsgDocument esbDoc = EsbmsgDocument.Factory.parse((Node)documentElement);
            EsbmsgDocument.Esbmsg esb = esbDoc.getEsbmsg();
            XQMessage xqMsg = this.getEmptyXQMsg();
            return this.populateXQMessage(esb, xqMsg);
        }
        catch (Exception e) {
            throw new EsbMsgUtilsException("Not able to create XQMessage from esbmsg(xml) as Element", e, ctx);
        }
    }

    @Override
    public XQMessage createXQMessage(InputStream inputStream) throws EsbMsgUtilsException {
        EsbMsgUtilsContext ctx = new EsbMsgUtilsContext("Convert xml as InputStream to XQMessage");
        ctx.setObjectType("InputStream");
        ctx.setOperation("Get XQMessage from - esbmsg as InputStream");
        try {
            EsbmsgDocument esbDoc = EsbmsgDocument.Factory.parse((InputStream)inputStream);
            Element element = this.getElement(esbDoc);
            return this.createXQMessageInternal(element);
        }
        catch (Exception e) {
            throw new EsbMsgUtilsException("Not able to create XQMessage from esbmsg(xml) as InputStream", e, ctx);
        }
    }

    @Override
    public XQMessage createXQMessage(InputSource is) throws EsbMsgUtilsException {
        EsbMsgUtilsContext ctx = new EsbMsgUtilsContext("Convert xml as InputSource to XQMessage");
        ctx.setObjectType("InputSource");
        ctx.setOperation("Get XQMessage from - esbmsg as InputSource");
        try {
            InputStream input = is.getByteStream();
            EsbmsgDocument esbDoc = EsbmsgDocument.Factory.parse((InputStream)input);
            Element element = this.getElement(esbDoc);
            return this.createXQMessageInternal(element);
        }
        catch (Exception e) {
            throw new EsbMsgUtilsException("Not able to create XQMessage from esbmsg(xml) as InputSource", e, ctx);
        }
    }

    @Override
    public XQMessage createXQMessage(String s) throws EsbMsgUtilsException {
        EsbMsgUtilsContext ctx = new EsbMsgUtilsContext("Convert xml as String to XQMessage");
        ctx.setObjectType("String");
        ctx.setOperation("Get XQMessage from - esbmsg as as String");
        try {
            EsbmsgDocument esbDoc = EsbmsgDocument.Factory.parse((String)s);
            Element element = this.getElement(esbDoc);
            return this.createXQMessageInternal(element);
        }
        catch (Exception e) {
            throw new EsbMsgUtilsException("Not able to create XQMessage from esbmsg(xml) as String", e, ctx);
        }
    }

    @Override
    public XQPart createXQMessagePart(Element documentElement) throws EsbMsgUtilsException {
        return this.createXQPartInternal(documentElement);
    }

    private XQPart createXQPartInternal(Element documentElement) throws EsbMsgUtilsException {
        EsbMsgUtilsContext ctx = new EsbMsgUtilsContext("Convert xmlpart as Element to XQPart");
        ctx.setObjectType("Element");
        ctx.setOperation("Get XQPart from - esbmsg as Element");
        ctx.setElement(documentElement);
        Element esbElement = null;
        try {
            if ("part".equals(documentElement.getLocalName())) {
                esbElement = this.getEsbmsgElem(documentElement);
            }
            EsbmsgDocument esbDoc = EsbmsgDocument.Factory.parse(esbElement);
            EsbmsgDocument.Esbmsg esb = esbDoc.getEsbmsg();
            XQMessage xqMsg = this.getEmptyXQMsg();
            return this.populateXQPart(esb, xqMsg);
        }
        catch (Exception e) {
            throw new EsbMsgUtilsException("Not able to create XQPart from esbmsg(xml) as Element", e, ctx);
        }
    }

    private Element getEsbmsgElem(Element documentElement) {
        Element esbMsgElem = documentElement.getOwnerDocument().createElementNS(URI, "esbmsg");
        esbMsgElem.appendChild(documentElement);
        return esbMsgElem;
    }

    private XQPart populateXQPart(EsbmsgDocument.Esbmsg esb, XQMessage xqMsg) {
        EsbMsgUtilsContext ctx = new EsbMsgUtilsContext("Populate XQPart ");
        try {
            PartType[] part = esb.getPartArray();
            XQPart xqPart = this.getNewMsgPart(xqMsg, part[0]);
            ctx.setXqpart(xqPart);
            if (xqPart != null) {
                return xqPart;
            }
            return null;
        }
        catch (Exception e) {
            throw new EsbMsgUtilsException("Not able to create XQPart from Element", e, ctx);
        }
    }

    @Override
    public XQPart createXQMessagePart(InputStream inputStream) throws EsbMsgUtilsException {
        EsbMsgUtilsContext ctx = new EsbMsgUtilsContext("Convert xmlpart to XQPart");
        ctx.setObjectType("InputStream");
        ctx.setOperation("Get XQPart from - esbmsg as InputStream");
        try {
            EsbmsgDocument esbDoc = EsbmsgDocument.Factory.parse((InputStream)inputStream);
            Element element = this.getElement(esbDoc);
            return this.createXQPartInternal(element);
        }
        catch (Exception e) {
            throw new EsbMsgUtilsException("Not able to create XQPart from esbmsg(xml) as InputStream", e, ctx);
        }
    }

    @Override
    public XQPart createXQMessagePart(InputSource is) throws EsbMsgUtilsException {
        EsbMsgUtilsContext ctx = new EsbMsgUtilsContext("Convert xmlpart to XQPart");
        ctx.setObjectType("InputSource");
        ctx.setOperation("Get XQPart from - esbmsg as InputSource");
        try {
            InputStream inputStream = is.getByteStream();
            EsbmsgDocument esbDoc = EsbmsgDocument.Factory.parse((InputStream)inputStream);
            Element element = this.getElement(esbDoc);
            return this.createXQPartInternal(element);
        }
        catch (Exception e) {
            throw new EsbMsgUtilsException("Not able to create XQPart from esbmsg(xml) as InputSource", e, ctx);
        }
    }

    @Override
    public XQPart createXQMessagePart(String s) throws EsbMsgUtilsException {
        EsbMsgUtilsContext ctx = new EsbMsgUtilsContext("Convert xmlpart to XQPart");
        ctx.setObjectType("String");
        ctx.setOperation("Get XQPart from - esbmsg as String");
        try {
            EsbmsgDocument esbDoc = EsbmsgDocument.Factory.parse((String)s);
            Element element = this.getElement(esbDoc);
            return this.createXQPartInternal(element);
        }
        catch (Exception e) {
            throw new EsbMsgUtilsException("Not able to create XQPart from esbmsg(xml) as String", e, ctx);
        }
    }

    private XQMessage getEmptyXQMsg() {
        XQMessageFactoryImpl xqFactImpl = new XQMessageFactoryImpl();
        XQMessage msg = xqFactImpl.createMessage();
        return msg;
    }

    private Element getElement(EsbmsgDocument esbDoc) throws EsbMsgUtilsException {
        try {
            EsbmsgDocument.Esbmsg esb = esbDoc.getEsbmsg();
            Node node = esb.getDomNode();
            Document doc = node.getOwnerDocument();
            Element documentElement = doc.getDocumentElement();
            return documentElement;
        }
        catch (Exception e) {
            throw new EsbMsgUtilsException("Not able to get Element from EsbmsgDocument", e);
        }
    }

    private EsbmsgDocument getEsbmsgDocument(Element element) throws EsbMsgUtilsException {
        try {
            EsbmsgDocument esbDocument = EsbmsgDocument.Factory.newInstance();
            esbDocument = EsbmsgDocument.Factory.parse((Node)element);
            return esbDocument;
        }
        catch (Exception e) {
            throw new EsbMsgUtilsException("The Element cannot be parsed and cannot return an EsbmsgDocument", e);
        }
    }

    private static boolean isTextContent(String contentType) {
        try {
            MimeType mimeType = new MimeType(contentType);
            String type = mimeType.getPrimaryType();
            return "text".equals(type);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static Charset getCharset(String contentType) throws EsbMsgUtilsException {
        EsbMsgUtilsContext ctx = new EsbMsgUtilsContext("Get charset from content-type");
        ctx.setObjectType("contentType");
        ctx.setOperation("Get charset from content type else the platform default");
        try {
            MimeType mimeType = new MimeType(contentType);
            String charset = mimeType.getParameter("charset");
            if (charset != null) {
                return Charset.forName(charset);
            }
        }
        catch (Exception e) {
            throw new EsbMsgUtilsException("Not able to get charset", e, ctx);
        }
        return Charset.forName(System.getProperty("file.encoding"));
    }

    private static String getTextContent(InputStream inputStream, String contentType) throws EsbMsgUtilsException {
        EsbMsgUtilsContext ctx = new EsbMsgUtilsContext("Get Text content from the file reference");
        ctx.setObjectType("InputStream");
        ctx.setOperation("Get Text content based on the charset received from content-type");
        try {
            InputStreamReader r = new InputStreamReader(inputStream, XmlOldToXQMessageImpl.getCharset(contentType));
            BufferedReader br = new BufferedReader(r);
            StringBuffer buf = new StringBuffer();
            char[] cbuf = new char[4096];
            int i = 0;
            while ((i = br.read(cbuf, 0, cbuf.length)) != -1) {
                buf.append(cbuf, 0, i);
            }
            return buf.toString();
        }
        catch (Exception e) {
            throw new EsbMsgUtilsException("Not able to get Text content", e, ctx);
        }
    }

    private static byte[] getBinaryContent(InputStream inputStream) throws EsbMsgUtilsException {
        EsbMsgUtilsContext ctx = new EsbMsgUtilsContext("Get Binary content from the file reference");
        ctx.setObjectType("InputStream");
        ctx.setOperation("Get Binary content based on the charset received from content-type");
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int read = 0;
            byte[] buf = new byte[4096];
            while ((read = inputStream.read(buf)) != -1) {
                out.write(buf, 0, read);
            }
            return out.toByteArray();
        }
        catch (Exception e) {
            throw new EsbMsgUtilsException("Not able to get Binary content", e, ctx);
        }
    }

    private XQMessage setHeaders(EsbmsgDocument.Esbmsg esb, XQMessage msg) throws EsbMsgUtilsException {
        EsbMsgUtilsContext ctx = new EsbMsgUtilsContext("Set xml message headers in  XQMessage");
        ctx.setObjectType("HeaderType");
        ctx.setOperation("Set header name and value in XQMessage");
        HeaderType[] headerTypes = esb.getHeaderArray();
        int hdrCount = headerTypes.length;
        String hdrName = null;
        try {
            for (int i = 0; i < hdrCount; ++i) {
                Object jmsDestHeaderValue = null;
                hdrName = headerTypes[i].getName();
                try {
                    JMSHeaderAdapter adapter = (JMSHeaderAdapter)this.m_headerAdapterMap.get(hdrName);
                    if (adapter == null) {
                        adapter = this.defaultAdapter;
                    }
                    jmsDestHeaderValue = adapter.getJMSValue(headerTypes[i]);
                    this.useMap(msg, hdrName, jmsDestHeaderValue);
                    continue;
                }
                catch (Exception e) {
                    this.useMap(msg, hdrName, jmsDestHeaderValue);
                }
            }
            ctx.setXqmessage(msg);
        }
        catch (Exception e) {
            throw new EsbMsgUtilsException("Not able to set message headers", e, ctx);
        }
        return this.setProperties(esb, msg);
    }

    private void useMap(XQMessage msg, String hdrName, Object jmsDestHeaderValue) throws EsbMsgUtilsException {
        EsbMsgUtilsContext ctx = new EsbMsgUtilsContext("Non settable XQMessage Headers is put in a map");
        ctx.setObjectType("HeaderType");
        ctx.setHeaderName(hdrName);
        ctx.setHeaderValue(jmsDestHeaderValue);
        try {
            if (!this.setHeadersTest(msg, hdrName, jmsDestHeaderValue)) {
                this.putHdrsinMap(hdrName, jmsDestHeaderValue);
            }
        }
        catch (Exception e) {
            throw new EsbMsgUtilsException("Not able to put, nonsettable XQMessage Headers in map ,", e, ctx);
        }
    }

    private boolean setHeadersTest(XQMessage msg, String hdrName, Object jmsHdrVal) {
        boolean boolVal = false;
        if (jmsHdrVal != null) {
            try {
                msg.setHeaderValue(hdrName, jmsHdrVal);
                Object value = msg.getHeaderValue(hdrName);
                if (value != null) {
                    boolVal = jmsHdrVal.equals(value);
                }
            }
            catch (Exception e) {
                return boolVal;
            }
        }
        return boolVal;
    }

    private void putHdrsinMap(String hdrName, Object jmsHdr) {
        this.m_unProcessedheaders.put(hdrName, jmsHdr);
    }

    @Override
    public Map getUnprocessedHdrs() {
        return this.m_unProcessedheaders;
    }

    private XQMessage setProperties(EsbmsgDocument.Esbmsg esb, XQMessage msg) throws EsbMsgUtilsException {
        EsbMsgUtilsContext ctx = new EsbMsgUtilsContext("Set (esbmsg)xml message properties in XQPart");
        ctx.setObjectType("PropertyType");
        ctx.setOperation("Set property name and value in XQMessage");
        try {
            PropertyType[] propertyTypes = esb.getPropertyArray();
            int propertyCount = propertyTypes.length;
            String propName = null;
            String propValue = null;
            for (int i = 0; i < propertyCount; ++i) {
                propName = propertyTypes[i].getName();
                propValue = propertyTypes[i].getValue();
                this.useMap(msg, propName, propValue);
            }
            ctx.setXqmessage(msg);
        }
        catch (Exception e) {
            throw new EsbMsgUtilsException("Not able to set properties on message", e, ctx);
        }
        return msg;
    }

    private XQMessage setParts(EsbmsgDocument.Esbmsg esbmsg, XQMessage msg) throws EsbMsgUtilsException {
        EsbMsgUtilsContext ctx = new EsbMsgUtilsContext("Set (esbmsg)xml message parts in XQPart");
        ctx.setObjectType("PartType");
        ctx.setOperation("Set XQPart in XQMessage");
        PartType[] parts = esbmsg.getPartArray();
        int partCount = parts.length;
        try {
            for (int i = 0; i < partCount; ++i) {
                XQPart newPart = this.getNewMsgPart(msg, parts[i]);
                msg.addPart(newPart);
            }
            ctx.setXqmessage(msg);
        }
        catch (Exception e) {
            throw new EsbMsgUtilsException("Not able to set  parts on message", e, ctx);
        }
        return this.setBody(esbmsg, msg);
    }

    private XQMessage setBody(EsbmsgDocument.Esbmsg esbmsg, XQMessage msg) throws EsbMsgUtilsException {
        EsbMsgUtilsContext ctx = new EsbMsgUtilsContext("Set (esbmsg)xml message body part in XQPart");
        ctx.setObjectType("BodyType");
        ctx.setOperation("Set Body XQPart in XQMessage");
        try {
            BodyType body = esbmsg.getBody();
            if (body != null) {
                XQPart newPart = this.getNewMsgPart(msg, body);
                msg.addPart(newPart);
            }
            ctx.setXqmessage(msg);
        }
        catch (Exception e) {
            throw new EsbMsgUtilsException("Not able to set body part on message", e, ctx);
        }
        return msg;
    }

    private XQPart getNewMsgPart(XQMessage msg, BodyType bodyType) throws EsbMsgUtilsException {
        EsbMsgUtilsContext ctx = new EsbMsgUtilsContext("Get file type - message body part");
        ctx.setObjectType("BodyType");
        ctx.setOperation("Get file reference contents ");
        try {
            String contentId = bodyType.getContentId();
            String contentType = bodyType.getContentType();
            String fileRef = bodyType.getFileRef();
            boolean useFileRef = bodyType.getUseFileRef();
            Object partContents = null;
            if (fileRef != null && !"".equals(fileRef.trim())) {
                if (useFileRef) {
                    partContents = this.getFileContents(fileRef, contentType);
                }
            } else {
                Node node = bodyType.getDomNode();
                Node childNode = node.getFirstChild();
                if (childNode instanceof Text) {
                    partContents = childNode.getNodeValue();
                } else if (childNode instanceof Element) {
                    partContents = DOMUtils.serializeChildNodes((Element)((Element)childNode.getParentNode()));
                }
            }
            if (partContents == null) {
                partContents = XmlOldToXQMessageImpl.isTextContent(contentType) ? new String("") : (Object)new byte[0];
            }
            XQPart newPart = msg.createPart(partContents, contentType);
            newPart.setContentId(contentId);
            return newPart;
        }
        catch (Exception e) {
            throw new EsbMsgUtilsException("Not able to get part content ", e, ctx);
        }
    }

    private XQPart getNewMsgPart(XQMessage msg, PartType partType) throws EsbMsgUtilsException {
        EsbMsgUtilsContext ctx = new EsbMsgUtilsContext("Get file type - message part");
        ctx.setObjectType("PartType");
        ctx.setOperation("Get file reference contents");
        try {
            String contentId = partType.getContentId();
            String contentType = partType.getContentType();
            String fileRef = partType.getFileRef();
            boolean useFileRef = partType.getUseFileRef();
            Object partContents = null;
            if (fileRef != null && !"".equals(fileRef.trim())) {
                if (useFileRef) {
                    partContents = this.getFileContents(fileRef, contentType);
                }
            } else {
                Node node = partType.getDomNode();
                Node childNode = node.getFirstChild();
                if (childNode instanceof Text) {
                    partContents = childNode.getNodeValue();
                } else if (childNode instanceof Element) {
                    partContents = DOMUtils.serializeChildNodes((Element)((Element)childNode.getParentNode()));
                }
            }
            if (partContents == null) {
                partContents = XmlOldToXQMessageImpl.isTextContent(contentType) ? new String("") : (Object)new byte[0];
            }
            XQPart newPart = msg.createPart(partContents, contentType);
            newPart.setContentId(contentId);
            return newPart;
        }
        catch (Exception e) {
            throw new EsbMsgUtilsException("Not able to get part content", e, ctx);
        }
    }

    private Object getFileContents(String fileRef, String contentType) throws EsbMsgUtilsException {
        byte[] byArray;
        EsbMsgUtilsContext ctx = new EsbMsgUtilsContext("Get file contents ");
        ctx.setObjectType("file-Ref");
        ctx.setOperation("Get file contents as text or binary");
        InputStream inputStream = null;
        try {
            URL url = new URL(fileRef);
            try {
                inputStream = url.openStream();
            }
            catch (Exception e) {
                url = this.getClass().getClassLoader().getResource(url.getPath());
                if (url == null) {
                    throw e;
                }
                inputStream = url.openStream();
            }
            if (XmlOldToXQMessageImpl.isTextContent(contentType)) {
                String string = XmlOldToXQMessageImpl.getTextContent(inputStream, contentType);
                return string;
            }
            byArray = XmlOldToXQMessageImpl.getBinaryContent(inputStream);
        }
        catch (Exception e) {
            throw new EsbMsgUtilsException("Not able to get part file content", e, ctx);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Throwable e) {}
        }
        return byArray;
    }

    private XQMessage populateXQMessage(EsbmsgDocument.Esbmsg esb, XQMessage msg) throws EsbMsgUtilsException {
        try {
            this.m_unProcessedheaders.clear();
            return this.setParts(esb, this.setHeaders(esb, msg));
        }
        catch (Exception e) {
            throw new EsbMsgUtilsException("Not able to populate XQMessage", e);
        }
    }

    static class BooleanAdapter
    implements JMSHeaderAdapter {
        BooleanAdapter() {
        }

        @Override
        public Object getJMSValue(HeaderType headerType) {
            return new Boolean(Boolean.getBoolean(headerType.getValue()));
        }
    }

    static class IntAdapter
    implements JMSHeaderAdapter {
        IntAdapter() {
        }

        @Override
        public Object getJMSValue(HeaderType headerType) {
            return new Integer(Integer.parseInt(headerType.getValue()));
        }
    }

    static class LongAdapter
    implements JMSHeaderAdapter {
        LongAdapter() {
        }

        @Override
        public Object getJMSValue(HeaderType headerType) {
            return new Long(Long.parseLong(headerType.getValue()));
        }
    }

    static class NullAdapter
    implements JMSHeaderAdapter {
        NullAdapter() {
        }

        @Override
        public Object getJMSValue(HeaderType headerType) {
            return headerType.getValue();
        }
    }

    static interface JMSHeaderAdapter {
        public Object getJMSValue(HeaderType var1) throws Exception;
    }
}

