/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.service.common.util.variables;

import com.sonicsw.esb.service.common.impl.core.FileChangeManager;
import com.sonicsw.esb.service.common.util.CheckArg;
import com.sonicsw.esb.service.common.util.variables.VariableFactory;
import com.sonicsw.esb.service.common.util.variables.VariableResolver;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class PropertiesURLVariableResolver
implements VariableResolver,
VariableFactory,
ResourceLoaderAware,
FileChangeManager.FileChangeHandler {
    public static final String SCHEME = "property";
    public static final String DYNAMIC = "dynamic";
    private static final Logger logger = Logger.getLogger((String)(VariableResolver.class.getName() + '.' + "property"));
    private final Map cache = Collections.synchronizedMap(new HashMap());
    private final Map dynamicCache = Collections.synchronizedMap(new HashMap());
    private ResourceLoader resourceLoader = new DefaultResourceLoader();
    private FileChangeManager fileChangeManager = new NullFileChangeManager();

    public String getScheme() {
        return SCHEME;
    }

    @Override
    public VariableFactory.Variable getVariable(String variableStr) {
        return new PropertyFileVariable(variableStr);
    }

    public VariableFactory.Variable createVariable(String url, String propertyName) {
        return this.createVariable(url, propertyName, false);
    }

    public VariableFactory.Variable createVariable(String url, String propertyName, boolean dynamic) {
        return new PropertyFileVariable(url, propertyName, dynamic);
    }

    @Override
    public String resolve(String variableStr) {
        CheckArg.notNull(variableStr, "variableStr");
        PropertyFileVariable var = new PropertyFileVariable(variableStr);
        Properties properties = var.isDynamic() ? this.getDynamicProperties(var) : this.getProperties(var);
        return properties.getProperty(var.getPropertyName());
    }

    private Properties getProperties(PropertyFileVariable var) {
        Properties properties = (Properties)this.cache.get(var.getURL());
        if (properties == null) {
            properties = this.loadProperties(var);
            this.cache.put(var.getURL(), properties);
        }
        return properties;
    }

    private Properties getDynamicProperties(PropertyFileVariable var) {
        Properties properties = (Properties)this.dynamicCache.get(var.getURL());
        if (properties == null) {
            properties = this.loadProperties(var);
            if (this.fileChangeManager.supportsChangeNotifications(var.getURL())) {
                this.dynamicCache.put(var.getURL(), properties);
                this.fileChangeManager.registerFileChangeInterest(var.getURL(), this);
            }
        }
        return properties;
    }

    private Properties loadProperties(PropertyFileVariable var) {
        try {
            Resource resource = this.resourceLoader.getResource(var.getURL());
            Properties properties = new Properties();
            properties.load(resource.getInputStream());
            return properties;
        }
        catch (IOException excp) {
            throw new IllegalArgumentException("Unable to read properties file specified by variable: " + var.toString());
        }
    }

    @Override
    public void handleFileChange(String path) {
        this.dynamicCache.remove(path);
        this.fileChangeManager.unregisterFileChangeInterest(path, this);
    }

    public void setFileChangeManager(FileChangeManager fileChangeManager) {
        this.fileChangeManager = fileChangeManager;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public class PropertyFileVariable
    implements VariableFactory.Variable {
        private final String variableStr;
        private final String url;
        private final String propertyName;
        private final boolean dynamic;

        PropertyFileVariable(String url, String propertyName, boolean dynamic) {
            CheckArg.notEmpty(url, "url");
            CheckArg.notEmpty(propertyName, "propertyName");
            this.url = url;
            this.propertyName = propertyName;
            this.dynamic = dynamic;
            this.variableStr = PropertiesURLVariableResolver.SCHEME + (dynamic ? ":dynamic" : "") + ":" + url + '#' + propertyName;
        }

        PropertyFileVariable(String variableStr) {
            int fragmentIx;
            StringTokenizer parts = new StringTokenizer(variableStr, ":");
            if (!PropertiesURLVariableResolver.SCHEME.equals(parts.nextToken())) {
                throw new IllegalArgumentException("Not a 'property' variable: " + variableStr);
            }
            this.dynamic = PropertiesURLVariableResolver.DYNAMIC.equals(parts.nextToken());
            String url = variableStr.substring(PropertiesURLVariableResolver.SCHEME.length() + 1);
            if (this.dynamic) {
                url = url.substring(PropertiesURLVariableResolver.DYNAMIC.length() + 1);
            }
            if ((fragmentIx = url.lastIndexOf(35)) <= 0) {
                throw new IllegalArgumentException("Malformed properties URL variable string: '" + url + "'. No property name found. " + "Expected format is 'fileURL#propertName'.");
            }
            this.url = url.substring(0, fragmentIx);
            this.propertyName = url.substring(fragmentIx + 1);
            this.variableStr = variableStr;
        }

        public String getURL() {
            return this.url;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public boolean isDynamic() {
            return this.dynamic;
        }

        public String toString() {
            return this.variableStr;
        }
    }

    private static final class NullFileChangeManager
    implements FileChangeManager {
        private NullFileChangeManager() {
        }

        @Override
        public boolean supportsChangeNotifications(String path) {
            return false;
        }

        @Override
        public void registerFileChangeInterest(String path, FileChangeManager.FileChangeHandler handler) {
        }

        @Override
        public void unregisterFileChangeInterest(String path, FileChangeManager.FileChangeHandler handler) {
        }
    }
}

