/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.service.common.util.variables;

import java.util.regex.Pattern;

public class VariableConstants {
    public static final String START_DELIM = "${";
    public static final String END_DELIM = "}";
    public static final String ESCAPE = "\\";
    static final Pattern VARIABLE_PATTERN;

    private VariableConstants() {
    }

    public static String escape(String content) {
        StringBuffer result = new StringBuffer();
        char[] chars = content.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            result.append(ESCAPE);
            result.append(chars[i]);
        }
        return result.toString();
    }

    static {
        String start = VariableConstants.escape(START_DELIM);
        String normal = "[^" + VariableConstants.escape("\\}") + "]*";
        String escaped = "\\.";
        String end = VariableConstants.escape(END_DELIM);
        String regex = start + "(" + normal + "(?:" + escaped + normal + ")*" + ")" + end;
        VARIABLE_PATTERN = Pattern.compile(regex);
    }
}

